/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource;

import de.elpro.ewms.core.datasource.DataGroupType;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_datasource_group", uniqueConstraints={@UniqueConstraint(columnNames={"data_source", "name"})})
@Access(value=AccessType.PROPERTY)
public class DataGroup
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "datasource/datagroup";
    public static final URL DEFAULT_READ_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/plugin_obj.png");
    public static final URL DEFAULT_WRITE_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/frgmt_obj.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty namespace = new SimpleStringProperty();
    private final StringProperty properitesDefinition = new SimpleStringProperty();
    private final ObjectProperty<DataGroupType> type = new SimpleObjectProperty((Object)DataGroupType.Read);
    private final ObjectProperty<RawValuesViewType> writeValueSource = new SimpleObjectProperty((Object)RawValuesViewType.GlobalView);
    private final ObjectProperty<Integer> writeValueLastValidValueSearchTimespan = new SimpleObjectProperty((Object)0);
    private final ObjectProperty<Integer> updateRate = new SimpleObjectProperty();
    private final ObjectProperty<Integer> keepAlive = new SimpleObjectProperty();
    private final ObjectProperty<Raster> sampleRaster = new SimpleObjectProperty((Object)Raster.Second_1);
    private final BooleanProperty disableHistoricalImport = new SimpleBooleanProperty(false);
    private final ObjectProperty<DataSource> dataSource = new SimpleObjectProperty();
    private final ObjectProperty<String> iconUri = new SimpleObjectProperty((Object)DEFAULT_READ_ICON.toString());

    public DataGroup() {
        this.type.addListener((o, ov, nv) -> this.iconUri.set((Object)(nv.isRead() ? DEFAULT_READ_ICON.toString() : DEFAULT_WRITE_ICON.toString())));
    }

    public DataGroup(int id) {
        this();
        this.setId(id);
    }

    public DataGroup(DataSource opcServer) {
        this();
        this.setDataSource(opcServer);
    }

    public DataGroup(String name, DataGroupType type, DataSource opcServer) {
        this(opcServer);
        this.setName(name);
        this.setType(type);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_datasource_group_sequence")
    @SequenceGenerator(name="ewms_datasource_group_sequence", sequenceName="ewms_datasource_group_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(Integer id) {
        this.id.set((Object)id);
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="namespace")
    public String getNamespace() {
        return (String)this.namespace.get();
    }

    public void setNamespace(String namespace) {
        this.namespace.set((Object)namespace);
    }

    public final StringProperty namespaceProperty() {
        return this.namespace;
    }

    @Transient
    public String getResultNamespace(IDataSource currentDataSource) {
        String namespacePattern = this.getNamespace();
        Map<String, String> aliasKeyMap = currentDataSource.getPlcAliasMap();
        if (aliasKeyMap == null || aliasKeyMap.isEmpty()) {
            return namespacePattern;
        }
        for (Map.Entry<String, String> alias : aliasKeyMap.entrySet()) {
            String aliasKeyPlaceholder = String.format("{%s}", alias.getKey());
            namespacePattern = namespacePattern.replace(aliasKeyPlaceholder, alias.getValue());
        }
        return namespacePattern;
    }

    @Column(name="properties_definition", columnDefinition="TEXT")
    public String getPropertiesDefinition() {
        return (String)this.properitesDefinition.get();
    }

    public void setPropertiesDefinition(String properties) {
        this.properitesDefinition.set((Object)properties);
    }

    public StringProperty propertiesDefinitionProperty() {
        return this.properitesDefinition;
    }

    @Column(name="type", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public DataGroupType getType() {
        return (DataGroupType)((Object)this.type.get());
    }

    public void setType(DataGroupType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<DataGroupType> typeProperty() {
        return this.type;
    }

    public final ObjectProperty<RawValuesViewType> writeValueSourceProperty() {
        return this.writeValueSource;
    }

    @Column(name="write_values_source", nullable=false, columnDefinition="INTEGER DEFAULT 1")
    public RawValuesViewType getWriteValueSource() {
        return (RawValuesViewType)((Object)this.writeValueSourceProperty().get());
    }

    public void setWriteValueSource(RawValuesViewType writeValueSource) {
        this.writeValueSourceProperty().set((Object)writeValueSource);
    }

    public ObjectProperty<Integer> writeValueLastValidValueSearchTimespanProperty() {
        return this.writeValueLastValidValueSearchTimespan;
    }

    @Column(name="write_values_last_valid_value_search_timespan", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public int getWriteValueLastValidValueSearchTimespan() {
        return (Integer)this.writeValueLastValidValueSearchTimespanProperty().get();
    }

    public void setWriteValueLastValidValueSearchTimespan(int writeValueLastValidValueSearchTimespan) {
        this.writeValueLastValidValueSearchTimespanProperty().set((Object)writeValueLastValidValueSearchTimespan);
    }

    @Column(name="update_rate")
    public Integer getUpdateRate() {
        return (Integer)this.updateRate.get();
    }

    public void setUpdateRate(Integer updateRate) {
        this.updateRate.set((Object)updateRate);
    }

    public final ObjectProperty<Integer> updateRateProperty() {
        return this.updateRate;
    }

    @Column(name="keep_alive")
    public Integer getKeepAlive() {
        return (Integer)this.keepAlive.get();
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive.set((Object)keepAlive);
    }

    public final ObjectProperty<Integer> keepAliveProperty() {
        return this.keepAlive;
    }

    @Column(name="sample_raster")
    public Raster getSampleRaster() {
        return (Raster)((Object)this.sampleRaster.get());
    }

    public void setSampleRaster(Raster raster) {
        this.sampleRaster.set((Object)raster);
    }

    public final ObjectProperty<Raster> sampleRasterProperty() {
        return this.sampleRaster;
    }

    public final BooleanProperty disableHistoricalImportProperty() {
        return this.disableHistoricalImport;
    }

    @Column(name="disable_historical_import", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isDisableHistoricalImport() {
        return this.disableHistoricalImportProperty().get();
    }

    public void setDisableHistoricalImport(boolean disableHistoricalImport) {
        this.disableHistoricalImportProperty().set(disableHistoricalImport);
    }

    @ManyToOne
    @JoinColumn(name="data_source", nullable=false)
    public DataSource getDataSource() {
        return (DataSource)this.dataSource.get();
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource.set((Object)dataSource);
    }

    public final ObjectProperty<DataSource> dataSourceProperty() {
        return this.dataSource;
    }

    public int compareTo(Object o) {
        if (!(o instanceof DataGroup)) {
            return -1;
        }
        return this.getName().compareTo(((DataGroup)o).getName());
    }

    public ObservableValue<String> iconUriProperty() {
        return this.iconUri;
    }

    @Transient
    public String getIconUri() {
        return (String)this.iconUri.get();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataGroup) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((DataGroup)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return DataGroup.class.hashCode() + 17 * (Integer)this.id.get();
    }
}

