/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource;

import java.util.HashMap;
import java.util.Map;

public enum IdentifierType {
    Numeric(0),
    String(1),
    UUID(2),
    Opaque(3);

    private final int value;
    private static final Map<Integer, IdentifierType> VALUES;

    static {
        VALUES = new HashMap<Integer, IdentifierType>();
        IdentifierType[] identifierTypeArray = IdentifierType.values();
        int n = identifierTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierType e = identifierTypeArray[n2];
            VALUES.put(e.getValue(), e);
            ++n2;
        }
    }

    private IdentifierType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static IdentifierType from(Integer value) {
        if (value == null) {
            return null;
        }
        return VALUES.getOrDefault(value, null);
    }
}

