/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua;

import de.elpro.ewms.core.primitivetypes.UInteger;
import java.util.HashMap;
import java.util.Map;

public enum NodeClass {
    Unspecified(0),
    Object(1),
    Variable(2),
    Method(4),
    ObjectType(8),
    VariableType(16),
    ReferenceType(32),
    DataType(64),
    View(128);

    private final int value;
    private static final Map<Integer, NodeClass> VALUES;

    static {
        VALUES = new HashMap<Integer, NodeClass>();
        NodeClass[] nodeClassArray = NodeClass.values();
        int n = nodeClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeClass e = nodeClassArray[n2];
            VALUES.put(e.getValue(), e);
            ++n2;
        }
    }

    private NodeClass(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static NodeClass from(Integer value) {
        if (value == null) {
            return null;
        }
        return VALUES.getOrDefault(value, null);
    }

    public static NodeClass valueOf(Integer value) {
        return value == null ? null : NodeClass.valueOf((int)value);
    }

    public static NodeClass valueOf(UInteger value) {
        return value == null ? null : NodeClass.valueOf(value.intValue());
    }

    public static NodeClass[] valueOf(int[] value) {
        NodeClass[] result = new NodeClass[value.length];
        int i = 0;
        while (i < value.length) {
            result[i] = NodeClass.valueOf(value[i]);
            ++i;
        }
        return result;
    }

    public static NodeClass[] valueOf(Integer[] value) {
        NodeClass[] result = new NodeClass[value.length];
        int i = 0;
        while (i < value.length) {
            result[i] = NodeClass.valueOf(value[i]);
            ++i;
        }
        return result;
    }

    public static NodeClass[] valueOf(UInteger[] value) {
        NodeClass[] result = new NodeClass[value.length];
        int i = 0;
        while (i < value.length) {
            result[i] = NodeClass.valueOf(value[i]);
            ++i;
        }
        return result;
    }

    public static NodeClass valueOf(String string) {
        return Enum.valueOf(NodeClass.class, string);
    }
}

