/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua;

import de.elpro.ewms.core.primitivetypes.UInteger;

public class SignalStatusCode {
    private static final long SEVERITY_MASK = 0xC0000000L;
    private static final long SEVERITY_GOOD = 0L;
    private static final long SEVERITY_UNCERTAIN = 0x40000000L;
    private static final long SEVERITY_BAD = 0x80000000L;
    public static final SignalStatusCode GOOD = new SignalStatusCode(0L);
    public static final SignalStatusCode UNCERTAIN = new SignalStatusCode(0x40000000L);
    public static final SignalStatusCode BAD = new SignalStatusCode(0x80000000L);
    private final long value;

    public SignalStatusCode(long value) {
        this.value = value;
    }

    public SignalStatusCode(int value) {
        this.value = value;
    }

    public SignalStatusCode(UInteger value) {
        this.value = value.longValue();
    }

    public long getValue() {
        return this.value;
    }

    public boolean isGood() {
        return (this.value & 0xC0000000L) == 0L;
    }

    public boolean isBad() {
        return (this.value & 0xC0000000L) == 0x80000000L;
    }

    public boolean isUncertain() {
        return (this.value & 0xC0000000L) == 0x40000000L;
    }

    public SignalStatusCode withOverflow() {
        return new SignalStatusCode(this.value | 0x480L);
    }

    public SignalStatusCode withoutOverflow() {
        return new SignalStatusCode(this.value & 0xFFFFFFFFFFFFFB7FL);
    }

    public boolean isOverflowSet() {
        return (this.value & 0x480L) == 1152L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalStatusCode that = (SignalStatusCode)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    private static String quality(SignalStatusCode statusCode) {
        if (statusCode.isGood()) {
            return "good";
        }
        if (statusCode.isBad()) {
            return "bad";
        }
        if (statusCode.isUncertain()) {
            return "uncertain";
        }
        return "unknown";
    }
}

