/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua;

public enum SignalValueDataType {
    Argument(296),
    BaseDataType(24),
    Boolean(1),
    Byte(3),
    ByteString(15),
    DateTime(13),
    Double(11),
    Duration(290),
    Enumeration(29),
    EnumValueType(7594),
    ExpandedNodeId(18),
    Float(10),
    Guid(14),
    IdType(256),
    Image(30),
    ImageBMP(2000),
    ImageGIF(2001),
    ImageJPG(2002),
    ImagePNG(2003),
    Integer(27),
    Int16(4),
    Int32(6),
    Int64(8),
    LocaleId(295),
    LocalizedText(21),
    NamingRuleType(120),
    NodeClass(257),
    NodeId(17),
    None(0),
    Number(26),
    OptionSetType(11487),
    QualifiedName(20),
    SByte(2),
    StatusCode(19),
    String(12),
    Structure(22),
    Time(292),
    TimeZoneDataType(8912),
    UInteger(28),
    UInt16(5),
    UInt32(7),
    UInt64(9),
    UtcTime(294),
    XmlElement(16);

    private int value;

    private SignalValueDataType(int value) {
        this.value = value;
    }

    public boolean Compare(int i) {
        return this.value == i;
    }

    public int getValue() {
        return this.value;
    }

    public static SignalValueDataType getValue(int value) {
        SignalValueDataType[] signalValueDataTypes = SignalValueDataType.values();
        int i = 0;
        while (i < signalValueDataTypes.length) {
            if (signalValueDataTypes[i].Compare(value)) {
                return signalValueDataTypes[i];
            }
            ++i;
        }
        return None;
    }
}

