/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua.datatypes;

import com.google.common.base.MoreObjects;
import java.util.Locale;

public final class LocalizedText {
    public static final LocalizedText NULL_VALUE = new LocalizedText(null, null);
    private final String locale;
    private final String text;

    public LocalizedText() {
        this.locale = "";
        this.text = "";
    }

    public LocalizedText(String locale, String text) {
        this.locale = locale;
        this.text = text;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getText() {
        return this.text;
    }

    public static LocalizedText english(String text) {
        return new LocalizedText(Locale.ENGLISH.getLanguage(), text);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedText that = (LocalizedText)o;
        return (this.locale != null ? this.locale.equals(that.locale) : that.locale == null) && (this.text != null ? this.text.equals(that.text) : that.text == null);
    }

    public int hashCode() {
        int result = this.locale != null ? this.locale.hashCode() : 0;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("text = %s, locale = %s", this.text, this.locale);
    }

    public String serialize() {
        String txt = MoreObjects.toStringHelper((Object)this).add("text", (Object)this.text).add("locale", (Object)this.locale).toString();
        return txt;
    }

    public static LocalizedText parse(String s) {
        String text;
        String locale;
        block4: {
            locale = "";
            String namePart1 = "";
            text = "";
            if (s != null) {
                try {
                    int index = s.indexOf(123) + 1;
                    if (index >= 0 && index <= s.length()) {
                        namePart1 = s.substring(index, s.length() - 1);
                        String[] parts1 = namePart1.split(",");
                        String[] parts2 = parts1[0].split("=");
                        text = parts2.length > 1 && parts2[1] != null && !parts2[1].isEmpty() ? parts2[1] : "";
                        parts2 = parts1[1].split("=");
                        locale = parts2.length > 1 && parts2[1] != null && !parts2[1].isEmpty() ? parts2[1] : "";
                        break block4;
                    }
                    return new LocalizedText();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    System.out.println(s);
                }
            }
        }
        return new LocalizedText(locale, text);
    }
}

