/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.datasource.opcua.datatypes;

import de.elpro.ewms.core.datasource.opcua.SignalStatusCode;
import de.elpro.ewms.core.datasource.opcua.SignalValueDataType;
import de.elpro.ewms.core.primitivetypes.UInteger;
import java.time.Instant;

public class SignalDataValue {
    private Object value;
    private SignalValueDataType valueTypeId;
    private SignalStatusCode status;
    private Instant sourceTime;
    private UInteger sourcePicoseconds;
    private Instant serverTime;
    private UInteger serverPicoseconds;

    public SignalDataValue() {
        this.value = null;
        this.status = SignalStatusCode.BAD;
        this.sourceTime = null;
        this.sourcePicoseconds = UInteger.valueOf(0);
        this.serverTime = null;
        this.serverPicoseconds = UInteger.valueOf(0);
    }

    public SignalDataValue(long statusCode) {
        this(null, new SignalStatusCode(statusCode));
    }

    public SignalDataValue(SignalStatusCode statusCode) {
        this(null, statusCode, null);
    }

    public SignalDataValue(Object value) {
        this(value, SignalStatusCode.GOOD);
    }

    public SignalDataValue(Object value, SignalStatusCode status) {
        this(value, status, Instant.now());
    }

    public SignalDataValue(Object value, SignalStatusCode status, Instant time) {
        this(value, status, time, time);
    }

    public SignalDataValue(Object value, SignalStatusCode status, Instant sourceTime, Instant serverTime) {
        this(value, status, sourceTime, null, serverTime, null);
    }

    public SignalDataValue(Object value, SignalStatusCode status, Instant sourceTime, UInteger sourcePicoseconds, Instant serverTime, UInteger serverPicoseconds) {
        this.value = value;
        this.status = status;
        this.sourceTime = sourceTime;
        this.sourcePicoseconds = sourcePicoseconds;
        this.serverTime = serverTime;
        this.serverPicoseconds = serverPicoseconds;
    }

    public Object getValue() {
        return this.value;
    }

    public Number getNummericValue() {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1.0 : 0.0;
        }
        if (this.value instanceof Instant) {
            return ((Instant)this.value).toEpochMilli();
        }
        return null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public SignalValueDataType getValueTypeId() {
        return this.valueTypeId;
    }

    public void setValueTypeId(SignalValueDataType valueTypeId) {
        this.valueTypeId = valueTypeId;
    }

    public SignalStatusCode getStatusCode() {
        return this.status;
    }

    public void setStatusCode(SignalStatusCode status) {
        this.status = status;
    }

    public Instant getSourceTime() {
        return this.sourceTime;
    }

    public void setSourceTime(Instant sourceTime) {
        this.sourceTime = sourceTime;
    }

    public UInteger getSourcePicoseconds() {
        return this.sourcePicoseconds;
    }

    public void setSourcePicoseconds(UInteger sourcePicoseconds) {
        this.sourcePicoseconds = sourcePicoseconds;
    }

    public Instant getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(Instant serverTime) {
        this.serverTime = serverTime;
    }

    public UInteger getServerPicoseconds() {
        return this.serverPicoseconds;
    }

    public void setServerPicoseconds(UInteger serverPicoseconds) {
        this.serverPicoseconds = serverPicoseconds;
    }

    public SignalDataValue withStatus(SignalStatusCode status) {
        return new SignalDataValue(this.value, status, this.sourceTime, this.serverTime);
    }

    public SignalDataValue withSourceTime(Instant sourceTime) {
        return new SignalDataValue(this.value, this.status, sourceTime, this.serverTime);
    }

    public SignalDataValue withServerTime(Instant serverTime) {
        return new SignalDataValue(this.value, this.status, this.sourceTime, serverTime);
    }
}

