/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.dataview;

import com.gluonhq.richtextarea.model.Document;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.dataview.AutoTimeRangeType;
import de.elpro.ewms.core.dataview.ViewNodeDocumentPlacementPolicy;
import de.elpro.ewms.core.dataview.ViewNodeDocumentPosition;
import de.elpro.ewms.core.dataview.ViewPerspective;
import de.elpro.ewms.core.dataview.ViewType;
import de.elpro.ewms.core.graph.GraphChart;
import de.elpro.ewms.core.json.Exclude;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.resources.ResourceLoader;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Table;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;

@Entity
@javax.persistence.Table(name="ewms_dataview_node")
@Access(value=AccessType.PROPERTY)
public class ViewNode
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "dataview/node";
    public static final URL TREE_ITEM_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"");
    public static final URL COMPLEX_VIEW_WITH_CONTENT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/client_complex_view_with_content.png");
    public static final URL COMPLEX_VIEW_WITHOUT_CONTENT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/client_complex_view_without_content.png");
    public static final URL TAB_CONTAINER_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/main_tab.png");
    public static final URL AUTO_TIME_RANGE_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/tables/timetable.png");
    public static final URL SPLIT_CONTAINER_VER_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/dataview/split_container_vertical.gif");
    public static final URL SPLIT_CONTAINER_HOR_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/dataview/split_container_horizontal.gif");
    public static final String ICONS_FOLDER = "ewms/icons/dataview/node";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<ViewPerspective> perspective = new SimpleObjectProperty();
    private final ObjectProperty<ViewNode> parent = new SimpleObjectProperty();
    private final BooleanProperty enable = new SimpleBooleanProperty(true);
    private final BooleanProperty isTreeItem = new SimpleBooleanProperty(true);
    private final ObjectProperty<StructureClass> dataClass = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> dataObject = new SimpleObjectProperty();
    private final ObjectProperty<SearchPolicy> dataObjectSearchPolicy = new SimpleObjectProperty();
    private final ObjectProperty<ViewType> viewType = new SimpleObjectProperty((Object)ViewType.Empty);
    private final StringProperty viewProperties = new SimpleStringProperty();
    private final BooleanProperty autoTimeRange = new SimpleBooleanProperty();
    private final ObjectProperty<AutoTimeRangeType> autoTimeRangeType = new SimpleObjectProperty((Object)AutoTimeRangeType.ViewNodeFirst);
    private final StringProperty customIconKey = new SimpleStringProperty();
    private final StringProperty customName = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<ViewNode> children = new ArrayList<ViewNode>();
    private final ObjectProperty<Orientation> splitContainerOrientation = new SimpleObjectProperty((Object)Orientation.VERTICAL);
    private final StringProperty splitContainerData = new SimpleStringProperty();
    private final BooleanProperty isSplitContainerFixed = new SimpleBooleanProperty(false);
    private final ObjectProperty<Integer> referenceObjectId = new SimpleObjectProperty();
    @Exclude
    private final ObjectProperty<Object> referenceObject = new SimpleObjectProperty();
    private final StringProperty partDescriptorId = new SimpleStringProperty();
    private final BooleanProperty showDocument = new SimpleBooleanProperty(false);
    private final ObjectProperty<ViewNodeDocumentPosition> documentPosition = new SimpleObjectProperty((Object)ViewNodeDocumentPosition.Top);
    private final ObjectProperty<ViewNodeDocumentPlacementPolicy> documentPlacementPolicy = new SimpleObjectProperty((Object)ViewNodeDocumentPlacementPolicy.ContentCentered);
    private final ObjectProperty<Double> preferedWidth = new SimpleObjectProperty();
    private final ObjectProperty<Double> documentPreferedHeight = new SimpleObjectProperty();
    private final ObjectProperty<Document> document = new SimpleObjectProperty();

    public ViewNode() {
        this.referenceObject.addListener(l -> {
            Object o = this.referenceObject.get();
            if (o instanceof IdObject) {
                this.setReferenceObjectId(((IdObject)o).getId());
            } else {
                this.setReferenceObjectId(null);
            }
        });
        this.viewType.addListener(il -> this.refreshReferenceObject());
        this.referenceObjectId.addListener(il -> this.refreshReferenceObject());
    }

    public ViewNode(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_dataview_node_sequence")
    @SequenceGenerator(name="ewms_dataview_node_sequence", sequenceName="ewms_dataview_node_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="perspective", nullable=true)
    public ViewPerspective getPerspective() {
        return (ViewPerspective)this.perspective.get();
    }

    public void setPerspective(ViewPerspective perspective) {
        this.perspective.set((Object)perspective);
    }

    public final ObjectProperty<ViewPerspective> viewPerspectiveProperty() {
        return this.perspective;
    }

    @ManyToOne
    @JoinColumn(name="parent", nullable=true)
    public ViewNode getParent() {
        return (ViewNode)this.parent.get();
    }

    public void setParent(ViewNode parent) {
        this.parent.set((Object)parent);
    }

    public final ObjectProperty<ViewNode> parentNodeProperty() {
        return this.parent;
    }

    public BooleanProperty enabledProperty() {
        return this.enable;
    }

    @Column(name="enable", nullable=false, columnDefinition="BOOLEAN DEFAULT TRUE")
    public boolean isEnabled() {
        return this.enabledProperty().get();
    }

    public void setEnabled(boolean enabled) {
        this.enabledProperty().set(enabled);
    }

    @Column(name="is_tree_item", nullable=false)
    public boolean isTreeItem() {
        return this.isTreeItem.get();
    }

    public void setTreeItem(boolean isTreeItem) {
        this.isTreeItem.set(isTreeItem);
    }

    @Transient
    public final BooleanProperty isTreeItemProperty() {
        return this.isTreeItem;
    }

    @ManyToOne
    @JoinColumn(name="data_class", nullable=true)
    public StructureClass getDataClass() {
        return (StructureClass)this.dataClass.get();
    }

    public void setDataClass(StructureClass dataClass) {
        this.dataClass.set((Object)dataClass);
    }

    public final ObjectProperty<StructureClass> dataClassProperty() {
        return this.dataClass;
    }

    @ManyToOne
    @JoinColumn(name="data_object", nullable=true)
    public StructureObject getDataObject() {
        return (StructureObject)this.dataObject.get();
    }

    public void setDataObject(StructureObject dataObject) {
        this.dataObject.set((Object)dataObject);
    }

    public final ObjectProperty<StructureObject> dataObjectProperty() {
        return this.dataObject;
    }

    public ObjectProperty<SearchPolicy> dataObjectSearchPolicyProperty() {
        return this.dataObjectSearchPolicy;
    }

    @Column(name="data_object_search_policy", nullable=true)
    public SearchPolicy getDataObjectSearchPolicy() {
        return (SearchPolicy)((Object)this.dataObjectSearchPolicyProperty().get());
    }

    public void setDataObjectSearchPolicy(SearchPolicy dataObjectSearchPolicy) {
        this.dataObjectSearchPolicyProperty().set((Object)dataObjectSearchPolicy);
    }

    @Column(name="view_type", nullable=false)
    public ViewType getViewType() {
        return (ViewType)((Object)this.viewType.get());
    }

    public void setViewType(ViewType viewType) {
        this.viewType.set((Object)viewType);
    }

    public final ObjectProperty<ViewType> viewTypeProperty() {
        return this.viewType;
    }

    public final StringProperty viewPropertiesProperty() {
        return this.viewProperties;
    }

    @Column(name="view_properties", columnDefinition="TEXT")
    public String getViewProperties() {
        return (String)this.viewPropertiesProperty().get();
    }

    public void setViewProperties(String viewProperties) {
        this.viewPropertiesProperty().set((Object)viewProperties);
    }

    @Column(name="auto_time_range", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isAutoTimeRange() {
        return this.autoTimeRange.get();
    }

    public void setAutoTimeRange(boolean autoTimeRange) {
        this.autoTimeRange.set(autoTimeRange);
    }

    public final BooleanProperty autoTimeRangeProperty() {
        return this.autoTimeRange;
    }

    @Column(name="auto_time_range_type", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public AutoTimeRangeType getAutoTimeRangeType() {
        return (AutoTimeRangeType)((Object)this.autoTimeRangeType.get());
    }

    public void setAutoTimeRangeType(AutoTimeRangeType autoTimeRangeType) {
        this.autoTimeRangeType.set((Object)autoTimeRangeType);
    }

    public final ObjectProperty<AutoTimeRangeType> autoTimeRangeTypeProperty() {
        return this.autoTimeRangeType;
    }

    @Column(name="custom_icon_key")
    public String getCustomIconKey() {
        return (String)this.customIconKey.get();
    }

    public void setCustomIconKey(String customIconKey) {
        this.customIconKey.set((Object)customIconKey);
    }

    public final StringProperty customIconKeyProperty() {
        return this.customIconKey;
    }

    @Column(name="custom_name", columnDefinition="TEXT")
    public String getCustomName() {
        return (String)this.customName.get();
    }

    @Transient
    public String getLocalCustomName() {
        return LocaleText.tryParse((String)this.getCustomName()).getTextOrDefault();
    }

    public void setCustomName(String customName) {
        this.customName.set((Object)customName);
    }

    public final StringProperty customNameProperty() {
        return this.customName;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @Column(name="split_container_orientation")
    public Orientation getSplitContainerOrientation() {
        return (Orientation)this.splitContainerOrientation.get();
    }

    public void setSplitContainerOrientation(Orientation orientation) {
        this.splitContainerOrientation.set((Object)orientation);
    }

    public final ObjectProperty<Orientation> splitContainerOrientationProperty() {
        return this.splitContainerOrientation;
    }

    @Column(name="split_container_data")
    public String getSplitContainerData() {
        return (String)this.splitContainerData.get();
    }

    public void setSplitContainerData(String splitterData) {
        this.splitContainerData.set((Object)splitterData);
    }

    public final StringProperty splitContainerDataProperty() {
        return this.splitContainerData;
    }

    @Column(name="split_container_fixed", columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isSplitContainerFixed() {
        return this.isSplitContainerFixed.get();
    }

    public void setSplitContainerFixed(boolean fixedSplitter) {
        this.isSplitContainerFixed.set(fixedSplitter);
    }

    @Transient
    public final BooleanProperty isSplitContainerFixedProperty() {
        return this.isSplitContainerFixed;
    }

    @Column(name="reference_object_id")
    public Integer getReferenceObjectId() {
        return (Integer)this.referenceObjectId.get();
    }

    public void setReferenceObjectId(Integer id) {
        this.referenceObjectId.set((Object)id);
    }

    public void refreshReferenceObject() {
        Object o = this.referenceObject.get();
        Integer id = (Integer)this.referenceObjectId.get();
        if (id == null) {
            this.referenceObject.set(null);
        } else {
            switch (this.getViewType()) {
                case Chart2D: {
                    if (o != null && id.equals(((Chart2D)o).getId())) break;
                    this.referenceObject.set((Object)new Chart2D(id));
                    break;
                }
                case Chart3D: {
                    if (o != null && id.equals(((Chart3D)o).getId())) break;
                    this.referenceObject.set((Object)new Chart3D(id));
                    break;
                }
                case SankeyChart: {
                    if (o != null && id.equals(((SankeyChart)o).getId())) break;
                    this.referenceObject.set((Object)new SankeyChart(id));
                    break;
                }
                case ChartGroup: {
                    if (o != null && id.equals(((ChartGroup)o).getId())) break;
                    this.referenceObject.set((Object)new ChartGroup(id));
                    break;
                }
                case Table: {
                    if (o != null && id.equals(((Table)o).getId())) break;
                    this.referenceObject.set((Object)new Table(id));
                    break;
                }
                case GraphChart: {
                    if (o != null && id.equals(((GraphChart)o).getId())) break;
                    this.referenceObject.set((Object)new GraphChart(id));
                    break;
                }
            }
        }
    }

    @Transient
    public Object getReferenceObject() {
        return this.referenceObject.get();
    }

    public void setReferenceObject(Object o) {
        this.referenceObject.set(o);
    }

    public final ObjectProperty<Object> referenceObjectProperty() {
        return this.referenceObject;
    }

    @Column(name="part_descriptor_id")
    public String getPartDescriptorId() {
        return (String)this.partDescriptorId.get();
    }

    public void setPartDescriptorId(String partDescriptorId) {
        this.partDescriptorId.set((Object)partDescriptorId);
    }

    public final StringProperty partDescriptorIdProperty() {
        return this.partDescriptorId;
    }

    public BooleanProperty showDocumentProperty() {
        return this.showDocument;
    }

    @Column(name="show_document", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isShowDocument() {
        return this.showDocumentProperty().get();
    }

    public void setShowDocument(boolean showDocument) {
        this.showDocumentProperty().set(showDocument);
    }

    public ObjectProperty<ViewNodeDocumentPosition> documentPositionProperty() {
        return this.documentPosition;
    }

    @Column(name="document_position", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public ViewNodeDocumentPosition getDocumentPosition() {
        return (ViewNodeDocumentPosition)((Object)this.documentPositionProperty().get());
    }

    public void setDocumentPosition(ViewNodeDocumentPosition documentPosition) {
        this.documentPositionProperty().set((Object)documentPosition);
    }

    public ObjectProperty<ViewNodeDocumentPlacementPolicy> documentPlacementPolicyProperty() {
        return this.documentPlacementPolicy;
    }

    @Column(name="document_placement_policy", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public ViewNodeDocumentPlacementPolicy getDocumentPlacementPolicy() {
        return (ViewNodeDocumentPlacementPolicy)((Object)this.documentPlacementPolicyProperty().get());
    }

    public void setDocumentPlacementPolicy(ViewNodeDocumentPlacementPolicy documentPlacementPolicy) {
        this.documentPlacementPolicyProperty().set((Object)documentPlacementPolicy);
    }

    public ObjectProperty<Double> documentPreferedWidthProperty() {
        return this.preferedWidth;
    }

    @Column(name="document_prefered_width")
    public Double getDocumentPreferedWidth() {
        return (Double)this.documentPreferedWidthProperty().get();
    }

    public void setDocumentPreferedWidth(Double documentPreferedWidth) {
        this.documentPreferedWidthProperty().set((Object)documentPreferedWidth);
    }

    @Column(name="document_prefered_height")
    public ObjectProperty<Double> documentPreferedHeightProperty() {
        return this.documentPreferedHeight;
    }

    public Double getDocumentPreferedHeight() {
        return (Double)this.documentPreferedHeightProperty().get();
    }

    public void setDocumentPreferedHeight(Double documentPreferedHeight) {
        this.documentPreferedHeightProperty().set((Object)documentPreferedHeight);
    }

    public ObjectProperty<Document> documentProperty() {
        return this.document;
    }

    @Transient
    public Document getDocument() {
        return (Document)this.documentProperty().get();
    }

    public void setDocument(Document document) {
        this.documentProperty().set((Object)document);
    }

    @Column(name="document", columnDefinition="TEXT")
    public String getDocumentSerialized() {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        return JsonUtils.GSON.toJson((Object)document);
    }

    public void setDocumentSerialized(String documentSerialized) {
        if (documentSerialized == null || documentSerialized.isBlank()) {
            this.setDocument(null);
        } else {
            this.setDocument((Document)JsonUtils.GSON.fromJson(documentSerialized, Document.class));
        }
    }

    @OneToMany(mappedBy="parent", cascade={CascadeType.REMOVE})
    public List<ViewNode> getChildren() {
        return this.children;
    }

    protected void setChildren(List<ViewNode> children) {
        this.children = children;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ViewNode)) {
            return false;
        }
        return this.hashCode() == ((ViewNode)obj).hashCode();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return ViewNode.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }

    public int compareTo(Object o) {
        if (!(o instanceof ViewNode)) {
            return super.compareTo(o);
        }
        ViewNode node = (ViewNode)o;
        if (node.isTreeItem() != this.isTreeItem()) {
            return this.isTreeItem() ? 1 : -1;
        }
        if (this.getVisualOrderPosition() != node.getVisualOrderPosition() && this.getVisualOrderPosition() != null && node.getVisualOrderPosition() != null) {
            return this.getVisualOrderPosition().compareTo(node.getVisualOrderPosition());
        }
        return super.compareTo(o);
    }

    @Transient
    public ImageView getTreeItemGraphic() {
        if (this.getCustomIconKey() != null && !this.getCustomIconKey().isEmpty()) {
            return new ImageView(ResourceLoader.getCachedIconPath(this.getCustomIconKey()));
        }
        ImageView graphic = null;
        if (this.getDataClass() != null && this.getDataClass().getIconUri() != null) {
            graphic = new ImageView(this.getDataClass().getIconUri());
        } else {
            switch (this.getViewType()) {
                case Empty: {
                    graphic = new ImageView(COMPLEX_VIEW_WITHOUT_CONTENT_ICON.toString());
                    break;
                }
                case TabContainer: {
                    graphic = new ImageView(TAB_CONTAINER_ICON.toString());
                    break;
                }
                case SplitContainer: {
                    if (this.getSplitContainerOrientation() == Orientation.VERTICAL) {
                        graphic = new ImageView(SPLIT_CONTAINER_VER_ICON.toString());
                        break;
                    }
                    graphic = new ImageView(SPLIT_CONTAINER_HOR_ICON.toString());
                    break;
                }
                case Chart2D: {
                    if (!(this.getReferenceObject() instanceof Chart2D)) break;
                    Chart2D chart = (Chart2D)this.getReferenceObject();
                    graphic = new ImageView(chart.getIconUri());
                    break;
                }
                case Chart3D: {
                    if (!(this.getReferenceObject() instanceof Chart3D)) break;
                    Chart3D chart = (Chart3D)this.getReferenceObject();
                    graphic = new ImageView(chart.getIconUri());
                    break;
                }
                case SankeyChart: {
                    graphic = new ImageView(SankeyChart.DEFAULT_ICON.toString());
                    break;
                }
                case ChartGroup: {
                    graphic = new ImageView(ChartGroup.DEFAULT_ICON.toString());
                    break;
                }
                case Table: {
                    graphic = new ImageView(Table.DEFAULT_ICON.toString());
                    break;
                }
                case ObjectProperties: {
                    graphic = new ImageView(PropertyGroup.DEFAULT_ICON.toString());
                    break;
                }
                case GraphChart: {
                    graphic = new ImageView(GraphChart.DEFAULT_ICON.toString());
                    break;
                }
                case Part: {
                    graphic = new ImageView(COMPLEX_VIEW_WITH_CONTENT_ICON.toString());
                    break;
                }
                case Notes: {
                    graphic = new ImageView(Note.DEFAULT_ICON.toString());
                    break;
                }
            }
        }
        return graphic;
    }

    public ObservableBooleanValue disabledProperty() {
        return Bindings.not((ObservableBooleanValue)this.enabledProperty());
    }

    @Transient
    public Node getGraphic() {
        Label treeItemIcon = null;
        if (this.isTreeItem()) {
            treeItemIcon = new Label("t");
            treeItemIcon.setPadding(new Insets(0.0));
            treeItemIcon.setLayoutX(0.0);
            treeItemIcon.setLayoutY(0.0);
            treeItemIcon.setPrefHeight(8.0);
            treeItemIcon.setTextFill((Paint)Color.BLACK);
            treeItemIcon.setStyle("-fx-font-weight: bold; -fx-font-style: italic; -fx-font-size: 10px;");
        }
        ImageView treeItemGraphic = this.getTreeItemGraphic();
        Group group = new Group();
        if (treeItemGraphic != null) {
            if (treeItemIcon != null) {
                treeItemGraphic.setFitWidth(12.0);
                treeItemGraphic.setFitHeight(12.0);
                treeItemGraphic.setX(4.0);
                treeItemGraphic.setY(4.0);
            }
            group.getChildren().add((Object)treeItemGraphic);
        }
        if (treeItemIcon != null) {
            group.getChildren().add((Object)treeItemIcon);
        }
        return group.getChildren().size() > 0 ? group : null;
    }

    public String toString() {
        String localCustomName = this.getLocalCustomName();
        if (localCustomName != null && !localCustomName.isEmpty()) {
            return localCustomName;
        }
        if (this.getDataClass() != null) {
            return this.getDataClass().toString();
        }
        switch (this.getViewType()) {
            case Chart2D: {
                if (this.getReferenceObject() != null) {
                    return this.getReferenceObject().toString();
                }
                return ViewType.Chart2D.toString();
            }
            case Chart3D: {
                if (this.getReferenceObject() != null) {
                    return this.getReferenceObject().toString();
                }
                return ViewType.Chart2D.toString();
            }
            case SankeyChart: {
                if (this.getReferenceObject() != null) {
                    return this.getReferenceObject().toString();
                }
                return ViewType.SankeyChart.toString();
            }
            case ChartGroup: {
                if (this.getReferenceObject() != null) {
                    return this.getReferenceObject().toString();
                }
                return ViewType.ChartGroup.toString();
            }
            case Table: {
                if (this.getReferenceObject() != null) {
                    return this.getReferenceObject().toString();
                }
                return ViewType.Table.toString();
            }
            case GraphChart: {
                if (this.getReferenceObject() != null) {
                    return this.getReferenceObject().toString();
                }
                return ViewType.GraphChart.toString();
            }
        }
        return this.getViewType().toString();
    }
}

