/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.dataview;

import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_dataview_perspective")
@Access(value=AccessType.PROPERTY)
public class ViewPerspective
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "dataview/perspective";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/navigation_tree.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty targetPartStackId = new SimpleStringProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty icon = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<ViewNode> rootNodes = new LinkedList<ViewNode>();

    public ViewPerspective() {
    }

    public ViewPerspective(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_dataview_perspective_sequence")
    @SequenceGenerator(name="ewms_dataview_perspective_sequence", sequenceName="ewms_dataview_perspective_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="target_part_stack_id")
    public String getTargetPartStackId() {
        return (String)this.targetPartStackId.get();
    }

    public void setTargetPartStackId(String targetPartStackId) {
        this.targetPartStackId.set((Object)targetPartStackId);
    }

    public final StringProperty targetPartStackIdProperty() {
        return this.targetPartStackId;
    }

    public StringProperty iconProperty() {
        return this.icon;
    }

    @Column(name="icon_uri")
    public String getIcon() {
        return (String)this.iconProperty().get();
    }

    public void setIcon(String iconUri) {
        this.iconProperty().set((Object)iconUri);
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="perspective", orphanRemoval=true, cascade={CascadeType.REMOVE})
    public List<ViewNode> getRootNodes() {
        return this.rootNodes;
    }

    protected void setRootNodes(List<ViewNode> rootNodes) {
        this.rootNodes = rootNodes;
    }

    @Transient
    public String getIconUri() {
        if (this.getIcon() != null && !this.getIcon().isBlank()) {
            return this.getIcon();
        }
        return DEFAULT_ICON.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ViewPerspective)) {
            return false;
        }
        return this.hashCode() == ((ViewPerspective)obj).hashCode();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return ViewPerspective.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }

    public String toString() {
        return this.getLocalName();
    }
}

