/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.dataview;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.graph.GraphChart;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.tables.Table;
import de.elpro.resources.Icons;
import de.elpro.ui.model.ComparableEnum;
import de.elpro.ui.model.UILabeledElement;
import javafx.scene.Node;
import javafx.scene.image.ImageView;

public enum ViewType implements UILabeledElement,
ComparableEnum
{
    Empty(0),
    TabContainer(1),
    SplitContainer(2),
    Table(3),
    Chart2D(4),
    SankeyChart(6),
    ChartGroup(10),
    Report(12),
    ObjectProperties(9),
    GraphChart(7),
    Part(11),
    Notes(8),
    Chart3D(5);

    private final int sortOrder;

    private ViewType(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Node getGraphic() {
        ImageView graphic = null;
        switch (this) {
            case Empty: {
                graphic = new ImageView(Icons.FOLDER_ITEM_URL.toString());
                break;
            }
            case TabContainer: {
                graphic = new ImageView(ViewNode.TAB_CONTAINER_ICON.toString());
                break;
            }
            case SplitContainer: {
                graphic = new ImageView(ViewNode.SPLIT_CONTAINER_VER_ICON.toString());
                break;
            }
            case Chart2D: {
                graphic = new ImageView(de.elpro.ewms.core.charts.Chart2D.XY_CHART_ICON.toString());
                break;
            }
            case Chart3D: {
                graphic = new ImageView(de.elpro.ewms.core.charts.Chart3D.DEFAULT_ICON.toString());
                break;
            }
            case SankeyChart: {
                graphic = new ImageView(de.elpro.ewms.core.charts.SankeyChart.DEFAULT_ICON.toString());
                break;
            }
            case ChartGroup: {
                graphic = new ImageView(de.elpro.ewms.core.charts.ChartGroup.DEFAULT_ICON.toString());
                break;
            }
            case Table: {
                graphic = new ImageView(de.elpro.ewms.core.tables.Table.DEFAULT_ICON.toString());
                break;
            }
            case ObjectProperties: {
                graphic = new ImageView(PropertyGroup.DEFAULT_ICON.toString());
                break;
            }
            case GraphChart: {
                graphic = new ImageView(de.elpro.ewms.core.graph.GraphChart.DEFAULT_ICON.toString());
                break;
            }
            case Part: {
                graphic = new ImageView(ViewNode.COMPLEX_VIEW_WITH_CONTENT_ICON.toString());
                break;
            }
            case Notes: {
                graphic = new ImageView(Note.DEFAULT_ICON.toString());
                break;
            }
        }
        return graphic;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }
}

