/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.db;

import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.ResultType;
import java.io.Serializable;

public class OperationResult {
    public static final OperationResult SUCCESS = new OperationResult(null, ResultType.Success);
    public static final OperationResult ACCESS_DENIED = new OperationResult(null, ResultType.UnexprectedError, "Acces Denied");
    public static final OperationResult UNSUPPORTED_OPERATION = new OperationResult(null, ResultType.UnexprectedError, "Unsupported Operation");
    private final Serializable objectId;
    private final ResultType type;
    private final String message;
    private final String internalMessage;

    public OperationResult(Serializable id, ResultType type) {
        this(id, type, null);
    }

    public OperationResult(ResultType type, String message) {
        this(null, type, message);
    }

    public OperationResult(Serializable id, ResultType type, String message) {
        this(id, type, message, null);
    }

    public OperationResult(ResultType type, String message, String internalMessage) {
        this(null, type, message, internalMessage);
    }

    public OperationResult(Serializable id, ResultType type, String message, String internalMessage) {
        this.objectId = id;
        this.type = type;
        this.message = message;
        this.internalMessage = internalMessage;
    }

    public Serializable getObjectId() {
        return this.objectId;
    }

    public ResultType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getInternalMessage() {
        return this.internalMessage;
    }

    public void raiseException() throws DAOOperationException {
        throw new DAOOperationException(this);
    }

    public String toString() {
        return String.format("[ObjectId: %s, Type: %s, Message: %s]", this.objectId, this.type.name(), this.message);
    }
}

