/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.events;

import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_events_event_action")
@Access(value=AccessType.PROPERTY)
public class EventAction
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "events/event_action";
    public static final URL DEFAULT_ICON_URL = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/server_event_action.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Event> event = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty jobId = new SimpleStringProperty();
    private final StringProperty executionParameters = new SimpleStringProperty();
    private final ObjectProperty<LogLevel> level = new SimpleObjectProperty((Object)LogLevel.INFO);
    private final StringProperty messagePattern = new SimpleStringProperty();
    private final BooleanProperty active = new SimpleBooleanProperty(true);

    public EventAction() {
    }

    public EventAction(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_events_event_action_sequence")
    @SequenceGenerator(name="ewms_events_event_action_sequence", sequenceName="ewms_events_event_action_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="event", nullable=false)
    public Event getEvent() {
        return (Event)this.event.get();
    }

    public void setEvent(Event event) {
        this.event.set((Object)event);
    }

    public final ObjectProperty<Event> eventProperty() {
        return this.event;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="job_id", nullable=false)
    public String getJobId() {
        return (String)this.jobId.get();
    }

    public void setJobId(String jobId) {
        this.jobId.set((Object)jobId);
    }

    public final StringProperty jobIdProperty() {
        return this.jobId;
    }

    @Column(name="execution_parameters", columnDefinition="TEXT")
    public String getExecutionParameters() {
        return (String)this.executionParameters.get();
    }

    public void setExecutionParameters(String executionParameters) {
        this.executionParameters.set((Object)executionParameters);
    }

    public final StringProperty executionParametersProperty() {
        return this.executionParameters;
    }

    @Column(name="level", nullable=false, columnDefinition="INTEGER DEFAULT 1")
    public LogLevel getLevel() {
        return (LogLevel)((Object)this.level.get());
    }

    public void setLevel(LogLevel level) {
        this.level.set((Object)level);
    }

    public final ObjectProperty<LogLevel> levelProperty() {
        return this.level;
    }

    @Column(name="message_pattern", columnDefinition="TEXT")
    public String getMessagePattern() {
        return (String)this.messagePattern.get();
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern.set((Object)messagePattern);
    }

    public final StringProperty messagePatternProperty() {
        return this.messagePattern;
    }

    @Column(name="active", nullable=false, columnDefinition="BOOLEAN DEFAULT TRUE")
    public boolean isActive() {
        return this.active.get();
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    public final BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventAction) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((EventAction)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return EventAction.class.hashCode() + 17 * (Integer)this.id.get();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON_URL.toString();
    }

    public String toString() {
        return this.getLocalName();
    }
}

