/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.export;

import de.elpro.ewms.core.export.ExportDataPolicy;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_export_data_profile")
@Access(value=AccessType.PROPERTY)
public class ExportDataProfile
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "export/data_profile";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/export_data_profile.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<RawValuesViewType> dataSourceValuesViewType = new SimpleObjectProperty((Object)RawValuesViewType.GlobalView);
    private final ObjectProperty<Integer> dataSourceValuesViewIndex = new SimpleObjectProperty();
    private final ObjectProperty<ComplexRaster> dataRaster = new SimpleObjectProperty();
    private final ObjectProperty<ComplexRaster> dataSliceSize = new SimpleObjectProperty((Object)ComplexRaster.OVERALL);
    private final StringProperty dataWriterId = new SimpleStringProperty();
    private final StringProperty dataWriterOptions = new SimpleStringProperty();
    private final ObjectProperty<Raster> executionInterval = new SimpleObjectProperty();
    private final ObjectProperty<Instant> lastExecution = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final ObjectProperty<ExportDataPolicy> exportPolicy = new SimpleObjectProperty((Object)ExportDataPolicy.All);
    private final BooleanProperty active = new SimpleBooleanProperty(true);
    private Set<VariableInstance> variableInstances = new LinkedHashSet<VariableInstance>();

    public ExportDataProfile() {
    }

    public ExportDataProfile(int id) {
        this.setId(id);
    }

    public ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_export_data_profile_sequence")
    @SequenceGenerator(name="ewms_export_data_profile_sequence", sequenceName="ewms_export_data_profile_sequence")
    public Integer getId() {
        return (Integer)this.idProperty().get();
    }

    void setId(Integer id) {
        this.idProperty().set((Object)id);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.nameProperty().get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public ObjectProperty<RawValuesViewType> dataSourceValuesViewTypeProperty() {
        return this.dataSourceValuesViewType;
    }

    @Column(name="data_source_values_view_type", nullable=false)
    public RawValuesViewType getDataSourceValuesViewType() {
        return (RawValuesViewType)((Object)this.dataSourceValuesViewTypeProperty().get());
    }

    public void setDataSourceValuesViewType(RawValuesViewType dataSourceValuesViewType) {
        this.dataSourceValuesViewTypeProperty().set((Object)dataSourceValuesViewType);
    }

    public ObjectProperty<Integer> dataSourceValuesViewIndexProperty() {
        return this.dataSourceValuesViewIndex;
    }

    @Column(name="data_source_values_view_index", nullable=true)
    public Integer getDataSourceValuesViewIndex() {
        return (Integer)this.dataSourceValuesViewIndexProperty().get();
    }

    public void setDataSourceValuesViewIndex(Integer dataSourceValuesViewIndex) {
        this.dataSourceValuesViewIndexProperty().set((Object)dataSourceValuesViewIndex);
    }

    public ObjectProperty<ComplexRaster> dataRasterProperty() {
        return this.dataRaster;
    }

    @Column(name="data_raster", nullable=false)
    public ComplexRaster getDataRaster() {
        return (ComplexRaster)this.dataRasterProperty().get();
    }

    public void setDataRaster(ComplexRaster dataRaster) {
        this.dataRasterProperty().set((Object)dataRaster);
    }

    public ObjectProperty<ComplexRaster> dataSliceSizeProperty() {
        return this.dataSliceSize;
    }

    @Column(name="data_slice_size", nullable=false)
    public ComplexRaster getDataSliceSize() {
        return (ComplexRaster)this.dataSliceSizeProperty().get();
    }

    public void setDataSliceSize(ComplexRaster dataSliceSize) {
        this.dataSliceSizeProperty().set((Object)dataSliceSize);
    }

    public StringProperty dataWriterIdProperty() {
        return this.dataWriterId;
    }

    @Column(name="data_writer_id", nullable=false, columnDefinition="TEXT")
    public String getDataWriterId() {
        return (String)this.dataWriterIdProperty().get();
    }

    public void setDataWriterId(String dataWriterId) {
        this.dataWriterIdProperty().set((Object)dataWriterId);
    }

    public StringProperty dataWriterOptionsProperty() {
        return this.dataWriterOptions;
    }

    @Column(name="data_writer_options", nullable=true, columnDefinition="TEXT")
    public String getDataWriterOptions() {
        return (String)this.dataWriterOptionsProperty().get();
    }

    public void setDataWriterOptions(String dataWriterOptions) {
        this.dataWriterOptionsProperty().set((Object)dataWriterOptions);
    }

    public ObjectProperty<Raster> executionIntervalProperty() {
        return this.executionInterval;
    }

    @Column(name="execution_interval", nullable=true)
    public Raster getExecutionInterval() {
        return (Raster)((Object)this.executionIntervalProperty().get());
    }

    public void setExecutionInterval(Raster executionInterval) {
        this.executionIntervalProperty().set((Object)executionInterval);
    }

    public ObjectProperty<Instant> lastExecutionProperty() {
        return this.lastExecution;
    }

    @Column(name="last_execution", nullable=true)
    public Instant getLastExecution() {
        return (Instant)this.lastExecutionProperty().get();
    }

    public void setLastExecution(Instant lastExecution) {
        this.lastExecutionProperty().set((Object)lastExecution);
    }

    @Column(name="description", columnDefinition="TEXT")
    public StringProperty descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.descriptionProperty().get();
    }

    public void setDescription(String description) {
        this.descriptionProperty().set((Object)description);
    }

    public final ObjectProperty<ExportDataPolicy> exportPolicyProperty() {
        return this.exportPolicy;
    }

    @Column(name="export_policy", nullable=false)
    public ExportDataPolicy getExportPolicy() {
        return (ExportDataPolicy)((Object)this.exportPolicyProperty().get());
    }

    public void setExportPolicy(ExportDataPolicy exportPolicy) {
        this.exportPolicyProperty().set((Object)exportPolicy);
    }

    public final BooleanProperty activeProperty() {
        return this.active;
    }

    @Column(name="active", nullable=false, columnDefinition="BOOLEAN DEFAULT TRUE")
    public boolean isActive() {
        return this.activeProperty().get();
    }

    public void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    @ManyToMany
    @JoinTable(name="ewms_export_data_profile_variable_instances", joinColumns={@JoinColumn(name="export_data_profile")}, inverseJoinColumns={@JoinColumn(name="variable_instance")})
    public Set<VariableInstance> getVariableInstances() {
        return this.variableInstances;
    }

    protected void setVariableInstances(Set<VariableInstance> variableInstances) {
        this.variableInstances = variableInstances;
    }

    public boolean applyInvalidationListener(VariableInstance instance) {
        ExportDataPolicy policy = this.getExportPolicy();
        return switch (policy) {
            case ExportDataPolicy.All -> true;
            case ExportDataPolicy.PLC -> {
                if (instance.getType() == VariableInstanceType.PLC) {
                    yield true;
                }
                yield false;
            }
            case ExportDataPolicy.NoPLC -> {
                if (instance.getType() != VariableInstanceType.PLC) {
                    yield true;
                }
                yield false;
            }
            case ExportDataPolicy.SelectedInstances -> this.getVariableInstances().contains((Object)instance);
            case ExportDataPolicy.UnselectedInstances -> {
                if (this.getVariableInstances().contains((Object)instance)) {
                    yield false;
                }
                yield true;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)policy));
        };
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public String toString() {
        return this.getLocalName();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return ExportDataProfile.class.hashCode() + 17 * this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExportDataProfile) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((ExportDataProfile)obj).getId())) {
                return true;
            }
        }
        return false;
    }
}

