/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.graph;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.graph.ObjectValue;
import de.elpro.ewms.core.graph.ObjectValues;
import de.elpro.ewms.core.json.Exclude;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ui.json.JsonReadWriteHelper;
import de.elpro.ui.text.LocaleText;
import java.io.IOException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;

public class ObjectGroup {
    private final StringProperty version = new SimpleStringProperty("1.0");
    private final StringProperty label = new SimpleStringProperty();
    private final ObjectProperty<Color> background = new SimpleObjectProperty();
    private final StringProperty backgroundSvg = new SimpleStringProperty();
    private final DoubleProperty contentWidth = new SimpleDoubleProperty(300.0);
    private final DoubleProperty contentHeight = new SimpleDoubleProperty(300.0);
    private final DoubleProperty contentLayoutX = new SimpleDoubleProperty();
    private final DoubleProperty contentLayoutY = new SimpleDoubleProperty();
    @Exclude
    private final ObjectProperty<ObjectGroup> parent = new SimpleObjectProperty();
    private final ObservableList<ObjectValues> objectValues = FXCollections.observableArrayList();
    private final ObservableList<ObjectGroup> objectGroups = FXCollections.observableArrayList();
    private static final GsonBuilder builder = new GsonBuilder();

    static {
        builder.serializeNulls();
        builder.registerTypeAdapter(ObjectGroup.class, (Object)new TypeAdapter<ObjectGroup>(){

            public void write(JsonWriter writer, ObjectGroup value) throws IOException {
                writer.beginObject();
                JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"label", (String)value.getLabel());
                JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"background_color", (Color)value.getBackgroundColor());
                JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"background_svg", (String)value.getBackgroundSvg());
                JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"width", (Double)value.getContentWidth());
                JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"height", (Double)value.getContentHeight());
                JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"layout_x", (Double)value.getContentLayoutX());
                JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"layout_y", (Double)value.getContentLayoutY());
                writer.name("object_groups");
                writer.beginArray();
                for (ObjectGroup childGroup : value.getObjectGroups()) {
                    this.write(writer, childGroup);
                }
                writer.endArray();
                writer.name("object_values");
                writer.beginArray();
                for (ObjectValues objectValues : value.getObjectValues()) {
                    writer.beginObject();
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"structure_object_id", objectValues.getStructureObject() != null ? objectValues.getStructureObject().getId() : null);
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"label", (String)objectValues.getLabel());
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"hide_label", (Boolean)objectValues.isHideLabel());
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"background_color", (Color)objectValues.getBackgroundColor());
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"border_color", (Color)objectValues.getBorderColor());
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"width", (Double)objectValues.getContentWidth());
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"height", (Double)objectValues.getContentHeight());
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"layout_x", (Double)objectValues.getContentLayoutX());
                    JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"layout_y", (Double)objectValues.getContentLayoutY());
                    writer.name("values");
                    writer.beginArray();
                    for (ObjectValue objectValue : objectValues.getValues()) {
                        writer.beginObject();
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"hide_ph", (Boolean)objectValue.isHidePhysicalUnit());
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"suffix", (String)objectValue.getSuffix());
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"variable_id", objectValue.getVariable() != null ? objectValue.getVariable().getId() : null);
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"unit", objectValue.getMeasuringUnit() != null ? objectValue.getMeasuringUnit().getId() : null);
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"format", objectValue.getFormat() != null ? objectValue.getFormat().getId() : null);
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"realtime_variable_id", objectValue.getRealtimeVariable() != null ? objectValue.getRealtimeVariable().getId() : null);
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"realtime_unit", objectValue.getRealtimeMeasuringUnit() != null ? objectValue.getRealtimeMeasuringUnit().getId() : null);
                        JsonReadWriteHelper.writeValue((JsonWriter)writer, (String)"realtime_format", objectValue.getRealtimeFormat() != null ? objectValue.getRealtimeFormat().getId() : null);
                        writer.endObject();
                    }
                    writer.endArray();
                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
            }

            public ObjectGroup read(JsonReader reader) throws IOException {
                reader.beginObject();
                ObjectGroup value = new ObjectGroup();
                value.setLabel(JsonReadWriteHelper.readString((JsonReader)reader));
                value.setBackgroundColor(JsonReadWriteHelper.readColor((JsonReader)reader));
                value.setBackgroundSvg(JsonReadWriteHelper.readString((JsonReader)reader));
                value.setContentWidth(JsonReadWriteHelper.readDouble((JsonReader)reader));
                value.setContentHeight(JsonReadWriteHelper.readDouble((JsonReader)reader));
                value.setContentLayoutX(JsonReadWriteHelper.readDouble((JsonReader)reader));
                value.setContentLayoutY(JsonReadWriteHelper.readDouble((JsonReader)reader));
                reader.nextName();
                reader.beginArray();
                while (reader.hasNext()) {
                    value.getObjectGroups().add((Object)this.read(reader));
                }
                reader.endArray();
                reader.nextName();
                reader.beginArray();
                while (reader.hasNext()) {
                    reader.beginObject();
                    ObjectValues ov = new ObjectValues();
                    Integer structureObjectId = JsonReadWriteHelper.readInteger((JsonReader)reader);
                    if (structureObjectId != null) {
                        ov.setStructureObject(new StructureObject(structureObjectId));
                    }
                    ov.setLabel(JsonReadWriteHelper.readString((JsonReader)reader));
                    ov.setHideLabel(JsonReadWriteHelper.readBool((JsonReader)reader));
                    ov.setBackgroundColor(JsonReadWriteHelper.readColor((JsonReader)reader));
                    ov.setBorderColor(JsonReadWriteHelper.readColor((JsonReader)reader));
                    ov.setContentWidth(JsonReadWriteHelper.readDouble((JsonReader)reader));
                    ov.setContentHeight(JsonReadWriteHelper.readDouble((JsonReader)reader));
                    ov.setContentLayoutX(JsonReadWriteHelper.readDouble((JsonReader)reader));
                    ov.setContentLayoutY(JsonReadWriteHelper.readDouble((JsonReader)reader));
                    reader.nextName();
                    reader.beginArray();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        ObjectValue ovv = new ObjectValue();
                        ovv.setHidePhysicalUnit(JsonReadWriteHelper.readBool((JsonReader)reader));
                        ovv.setSuffix(JsonReadWriteHelper.readString((JsonReader)reader));
                        Integer variableId = JsonReadWriteHelper.readInteger((JsonReader)reader);
                        if (variableId != null) {
                            ovv.setVariable(new Variable(variableId));
                        }
                        ovv.setMeasuringUnit(MeasuringUnit.getMeasuringUnit(JsonReadWriteHelper.readString((JsonReader)reader)));
                        ovv.setFormat(MeasuringUnitFormat.getMeasuringUnitFormat(JsonReadWriteHelper.readString((JsonReader)reader)));
                        Integer realtimeVariableId = JsonReadWriteHelper.readInteger((JsonReader)reader);
                        if (realtimeVariableId != null) {
                            ovv.setRealtimeVariable(new Variable(realtimeVariableId));
                        }
                        ovv.setRealtimeMeasuringUnit(MeasuringUnit.getMeasuringUnit(JsonReadWriteHelper.readString((JsonReader)reader)));
                        ovv.setRealtimeFormat(MeasuringUnitFormat.getMeasuringUnitFormat(JsonReadWriteHelper.readString((JsonReader)reader)));
                        reader.endObject();
                        ov.getValues().add((Object)ovv);
                    }
                    reader.endArray();
                    reader.endObject();
                    value.getObjectValues().add((Object)ov);
                }
                reader.endArray();
                reader.endObject();
                return value;
            }
        });
    }

    public String getLabel() {
        return (String)this.label.get();
    }

    public String getLocalLabel() {
        return LocaleText.tryParse((String)this.getLabel()).getTextOrDefault();
    }

    public void setLabel(String label) {
        this.label.set((Object)label);
    }

    public final StringProperty labelProperty() {
        return this.label;
    }

    public Color getBackgroundColor() {
        return (Color)this.background.get();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.background.set((Object)backgroundColor);
    }

    public final ObjectProperty<Color> backgroundColorProperty() {
        return this.background;
    }

    public String getBackgroundSvg() {
        return (String)this.backgroundSvg.get();
    }

    public void setBackgroundSvg(String backgroundSvg) {
        this.backgroundSvg.set((Object)backgroundSvg);
    }

    public final StringProperty backgroundSvgProperty() {
        return this.backgroundSvg;
    }

    public double getContentWidth() {
        return this.contentWidth.get();
    }

    public void setContentWidth(double width) {
        this.contentWidth.set(width);
    }

    public final DoubleProperty contentWidthProperty() {
        return this.contentWidth;
    }

    public double getContentHeight() {
        return this.contentHeight.get();
    }

    public void setContentHeight(double height) {
        this.contentHeight.set(height);
    }

    public final DoubleProperty contentHeightProperty() {
        return this.contentHeight;
    }

    public double getContentLayoutX() {
        return this.contentLayoutX.get();
    }

    public void setContentLayoutX(double layoutX) {
        this.contentLayoutX.set(layoutX);
    }

    public final DoubleProperty contentLayoutXProperty() {
        return this.contentLayoutX;
    }

    public double getContentLayoutY() {
        return this.contentLayoutY.get();
    }

    public void setContentLayoutY(double layoutY) {
        this.contentLayoutY.set(layoutY);
    }

    public final DoubleProperty contentLayoutYProperty() {
        return this.contentLayoutY;
    }

    public ObjectGroup getParent() {
        return (ObjectGroup)this.parent.get();
    }

    public void setParent(ObjectGroup objectGroup) {
        this.parent.set((Object)objectGroup);
    }

    public final ObjectProperty<ObjectGroup> parentProperty() {
        return this.parent;
    }

    public ObservableList<ObjectValues> getObjectValues() {
        return this.objectValues;
    }

    public ObservableList<ObjectGroup> getObjectGroups() {
        return this.objectGroups;
    }

    public String toJson() {
        return JsonUtils.GSON.toJson((Object)this);
    }

    public static ObjectGroup parse(String text) {
        if (text != null && !text.isBlank() && !text.replace("\r", "").replace("\n", "").startsWith("{  \"version\":")) {
            ObjectGroup objectGroup = (ObjectGroup)builder.create().fromJson(text, ObjectGroup.class);
            return objectGroup;
        }
        return (ObjectGroup)JsonUtils.GSON.fromJson(text, ObjectGroup.class);
    }

    public String toString() {
        return this.toJson();
    }
}

