/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json;

import de.elpro.ewms.core.bundle.Activator;
import de.elpro.ewms.core.json.JsonElement;
import de.elpro.ewms.core.json.JsonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.eclipse.fx.core.log.Logger;

public class JsonParser
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final Logger logger = Activator.createLogger(JsonParser.class);
    private static final boolean DEBUG = Boolean.valueOf(System.getProperty("com.eos.debug.json", "false"));

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (!DEBUG) {
                Throwable throwable = null;
                Object var8_11 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(entityStream));){
                    return JsonUtils.GSON.fromJson((Reader)bufferedReader, type);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            String result = new BufferedReader(new InputStreamReader(entityStream)).lines().collect(Collectors.joining("\n"));
            System.out.println("Incomming: " + result);
            return JsonUtils.GSON.fromJson(result, type);
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (Throwable exc) {
            logger.error("Error reading stream", exc);
            throw new IOException(exc);
        }
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        block15: {
            Object o;
            if (t instanceof JsonElement) {
                ((JsonElement)t).beforeWriteToJson();
            }
            if (t instanceof JsonElement[]) {
                JsonElement[] jsonElementArray = (JsonElement[])t;
                int n = jsonElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    o = jsonElementArray[n2];
                    o.beforeWriteToJson();
                    ++n2;
                }
            }
            try {
                if (!DEBUG) {
                    o = null;
                    Object var9_12 = null;
                    try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(entityStream));){
                        JsonUtils.GSON.toJson(t, (Appendable)bufferedWriter);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        if (o == null) {
                            o = throwable;
                        } else if (o != throwable) {
                            ((Throwable)o).addSuppressed(throwable);
                        }
                        throw o;
                    }
                }
                String json = JsonUtils.GSON.toJson(t);
                System.out.println("Outcomming: " + json);
                entityStream.write(json.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable exc) {
                logger.error("Error writing stream", exc);
                throw new IOException(exc);
            }
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }
}

