/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.ImageDecoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.TableDecoration;
import com.gluonhq.richtextarea.model.TextDecoration;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.editors.model.ResourceImageDecoration;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import java.io.IOException;

public class DecorationTypeAdapter
extends NotNullValueTypeAdapter<Decoration> {
    private static final String IMAGE_DECORATION_CLASS = ImageDecoration.class.getName();
    private static final String PARAGRAPH_DECORATION_CLASS = ParagraphDecoration.class.getName();
    private static final String TABLE_DECORATION_CLASS = TableDecoration.class.getName();
    private static final String TEXT_DECORATION_CLASS = TextDecoration.class.getName();
    private static final String RESOURCE_IMAGE_DECORATION_CLASS = ResourceImageDecoration.class.getName();

    @Override
    public void writeNotEmpty(JsonWriter out, Decoration value) throws IOException {
        out.beginObject();
        out.name("class_name");
        out.value(value.getClass().getName());
        out.name("object");
        if (value instanceof ImageDecoration) {
            JsonUtils.GSON.toJson((Object)value, ImageDecoration.class, out);
        } else if (value instanceof ParagraphDecoration) {
            JsonUtils.GSON.toJson((Object)value, ParagraphDecoration.class, out);
        } else if (value instanceof TableDecoration) {
            JsonUtils.GSON.toJson((Object)value, TableDecoration.class, out);
        } else if (value instanceof TextDecoration) {
            JsonUtils.GSON.toJson((Object)value, TextDecoration.class, out);
        } else if (value instanceof ResourceImageDecoration) {
            JsonUtils.GSON.toJson((Object)value, ResourceImageDecoration.class, out);
        } else {
            out.nullValue();
        }
        out.endObject();
    }

    @Override
    public Decoration readNotEmpty(JsonReader in) throws IOException {
        in.beginObject();
        in.nextName();
        String className = in.nextString();
        in.nextName();
        Object decoration = IMAGE_DECORATION_CLASS.equals(className) ? (Decoration)JsonUtils.GSON.fromJson(in, ImageDecoration.class) : (PARAGRAPH_DECORATION_CLASS.equals(className) ? (Decoration)JsonUtils.GSON.fromJson(in, ParagraphDecoration.class) : (TABLE_DECORATION_CLASS.equals(className) ? (Decoration)JsonUtils.GSON.fromJson(in, TableDecoration.class) : (TEXT_DECORATION_CLASS.equals(className) ? (Decoration)JsonUtils.GSON.fromJson(in, TextDecoration.class) : (RESOURCE_IMAGE_DECORATION_CLASS.equals(className) ? (Decoration)JsonUtils.GSON.fromJson(in, ResourceImageDecoration.class) : null))));
        in.endObject();
        return decoration;
    }
}

