/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.calculated.dependencies.Characteristic2DDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKeyType;
import de.elpro.ewms.core.variable.calculated.dependencies.ExplicitDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.LinkDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.LowerLimitDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.ObjectPropertyDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.PropertyReferenceDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.UpperLimitDependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableReferenceDependencyKey;
import de.elpro.ewms.core.variable.custom.AlgorithmDescriptor;
import java.io.IOException;

public class DependencyKeyTypeAdapter
extends NotNullValueTypeAdapter<DependencyKey<?>> {
    @Override
    public void writeNotEmpty(JsonWriter out, DependencyKey<?> value) throws IOException {
        out.beginObject();
        DependencyKeyTypeAdapter.writeValue(out, "type", value.getType());
        out.name("id");
        switch (value.getType()) {
            case LowerLimit: 
            case UpperLimit: 
            case Link: {
                out.nullValue();
                break;
            }
            case ExplicitDependency: 
            case VariableReference: 
            case Characteristic2D: {
                out.value((String)value.getId());
                break;
            }
            case CustomAlgorithm: {
                JsonUtils.GSON.toJson(value.getId(), AlgorithmDescriptor.class, out);
                break;
            }
            case ObjectProperty: {
                JsonUtils.GSON.toJson(value.getId(), StructureObject.class, out);
                break;
            }
            case PropertyReference: {
                out.value((String)value.getId());
                break;
            }
            default: {
                out.nullValue();
            }
        }
        out.endObject();
    }

    @Override
    public DependencyKey<?> readNotEmpty(JsonReader in) throws IOException {
        in.beginObject();
        try {
            DependencyKeyType type = DependencyKeyTypeAdapter.readEnum("type", in, DependencyKeyType.class);
            DependencyKeyTypeAdapter.readName("id", in);
            switch (type) {
                case Link: {
                    in.nextNull();
                    LinkDependencyKey linkDependencyKey = new LinkDependencyKey();
                    return linkDependencyKey;
                }
                case LowerLimit: {
                    in.nextNull();
                    LowerLimitDependencyKey lowerLimitDependencyKey = new LowerLimitDependencyKey();
                    return lowerLimitDependencyKey;
                }
                case UpperLimit: {
                    in.nextNull();
                    UpperLimitDependencyKey upperLimitDependencyKey = new UpperLimitDependencyKey();
                    return upperLimitDependencyKey;
                }
                case Characteristic2D: {
                    Characteristic2DDependencyKey characteristic2DDependencyKey = new Characteristic2DDependencyKey(in.nextString());
                    return characteristic2DDependencyKey;
                }
                case VariableReference: {
                    VariableReferenceDependencyKey variableReferenceDependencyKey = new VariableReferenceDependencyKey(in.nextString());
                    return variableReferenceDependencyKey;
                }
                case ExplicitDependency: {
                    if (in.peek() == JsonToken.STRING) {
                        ExplicitDependencyKey explicitDependencyKey = new ExplicitDependencyKey(in.nextString());
                        return explicitDependencyKey;
                    }
                    in.nextNull();
                    ExplicitDependencyKey explicitDependencyKey = new ExplicitDependencyKey(null);
                    return explicitDependencyKey;
                }
                case CustomAlgorithm: {
                    CustomAlgorithmDependencyKey customAlgorithmDependencyKey = new CustomAlgorithmDependencyKey((AlgorithmDescriptor)JsonUtils.GSON.fromJson(in, AlgorithmDescriptor.class));
                    return customAlgorithmDependencyKey;
                }
                case ObjectProperty: {
                    ObjectPropertyDependencyKey objectPropertyDependencyKey = new ObjectPropertyDependencyKey((StructureObject)JsonUtils.GSON.fromJson(in, StructureObject.class));
                    return objectPropertyDependencyKey;
                }
                case PropertyReference: {
                    PropertyReferenceDependencyKey propertyReferenceDependencyKey = new PropertyReferenceDependencyKey(in.nextString());
                    return propertyReferenceDependencyKey;
                }
            }
            in.nextNull();
            return null;
        }
        finally {
            in.endObject();
        }
    }
}

