/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DoubleArrayArrayTypeAdapter
extends NotNullValueTypeAdapter<double[][]> {
    @Override
    public void writeNotEmpty(JsonWriter out, double[][] value) throws IOException {
        int size = 0;
        int i = 0;
        while (i < value.length) {
            size += 4 + value[i].length * 8;
            ++i;
        }
        byte[] byteArray = new byte[4 + size];
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        bb.putInt(value.length);
        int i2 = 0;
        while (i2 < value.length) {
            bb.putInt(value[i2].length);
            int j = 0;
            while (j < value[i2].length) {
                bb.putDouble(value[i2][j]);
                ++j;
            }
            ++i2;
        }
        DoubleArrayArrayTypeAdapter.writeValue(out, bb.array());
    }

    @Override
    public double[][] readNotEmpty(JsonReader in) throws IOException {
        byte[] byteArray = DoubleArrayArrayTypeAdapter.readBytes(in);
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        int outerArrayLength = bb.getInt();
        double[][] resultArray = new double[outerArrayLength][];
        int outerArrayIndex = 0;
        while (bb.hasRemaining()) {
            int innerArrayLength = bb.getInt();
            double[] innerArray = new double[innerArrayLength];
            int i = 0;
            while (i < innerArray.length) {
                innerArray[i] = bb.getDouble();
                ++i;
            }
            resultArray[outerArrayIndex++] = innerArray;
        }
        return resultArray;
    }
}

