/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.elpro.ui.model.IdObject;
import java.io.IOException;

public class IdObjTypeAdapter<T extends IdObject>
extends TypeAdapter<T> {
    private final Class<?> clazz;

    public IdObjTypeAdapter(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.beginObject();
            out.name("id");
            if (value.getId() != null) {
                out.value((Number)value.getId());
            } else {
                out.nullValue();
            }
            out.endObject();
        }
    }

    public T read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        try {
            IdObject o;
            String name = in.nextName();
            if (!"id".equals(name)) {
                throw new IllegalStateException("Wrong field name: " + name);
            }
            if (in.peek() == JsonToken.NULL) {
                IdObject o2;
                in.nextNull();
                IdObject idObject = o2 = (IdObject)this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                return (T)idObject;
            }
            IdObject idObject = o = (IdObject)this.clazz.getConstructor(Integer.TYPE).newInstance(in.nextInt());
            return (T)idObject;
        }
        catch (Exception ne) {
            ne.printStackTrace();
            return null;
        }
        finally {
            in.endObject();
        }
    }
}

