/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import java.io.IOException;
import java.io.Serializable;

public class OperationResultTypeAdapter
extends NotNullValueTypeAdapter<OperationResult> {
    @Override
    protected OperationResult readNotEmpty(JsonReader reader) throws IOException {
        Object objectId = null;
        ResultType type = null;
        String message = null;
        String internalMessage = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name;
            switch (name = reader.nextName()) {
                case "object_id": {
                    if (reader.peek() == JsonToken.NUMBER) {
                        objectId = reader.nextInt();
                        break;
                    }
                    if (reader.peek() == JsonToken.STRING) {
                        objectId = reader.nextString();
                        break;
                    }
                    reader.nextNull();
                    break;
                }
                case "type": {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        break;
                    }
                    type = Enum.valueOf(ResultType.class, reader.nextString());
                    break;
                }
                case "message": {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        break;
                    }
                    message = reader.nextString();
                    break;
                }
                case "internal_message": {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        break;
                    }
                    internalMessage = reader.nextString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + name);
                }
            }
        }
        reader.endObject();
        return new OperationResult((Serializable)objectId, type, message, internalMessage);
    }

    @Override
    protected void writeNotEmpty(JsonWriter writer, OperationResult value) throws IOException {
        writer.beginObject();
        writer.name("object_id");
        if (value.getObjectId() instanceof Integer) {
            writer.value((Number)((Integer)value.getObjectId()));
        } else if (value.getObjectId() != null) {
            writer.value(value.getObjectId().toString());
        } else {
            writer.nullValue();
        }
        OperationResultTypeAdapter.writeValue(writer, "type", value.getType());
        OperationResultTypeAdapter.writeValue(writer, "message", value.getMessage());
        OperationResultTypeAdapter.writeValue(writer, "internal_message", value.getInternalMessage());
        writer.endObject();
    }
}

