/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.bundle.Activator;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import de.elpro.ewms.core.time.TimeIntervalStringValueCollection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.eclipse.fx.core.log.Logger;

public class TimeIntervalStringValueCollectionTypeAdapter
extends NotNullValueTypeAdapter<TimeIntervalStringValueCollection> {
    private static Logger logger = Activator.createLogger(TimeIntervalStringValueCollectionTypeAdapter.class);
    private static LZ4Factory compressorFactory = LZ4Factory.fastestInstance();

    @Override
    protected TimeIntervalStringValueCollection readNotEmpty(JsonReader reader) throws IOException {
        reader.beginObject();
        int size = TimeIntervalStringValueCollectionTypeAdapter.readInt("size", reader);
        long[] fromTsArray = TimeIntervalStringValueCollectionTypeAdapter.toLongArray(TimeIntervalStringValueCollectionTypeAdapter.readBytes("from_ts", reader));
        long[] toTsArray = TimeIntervalStringValueCollectionTypeAdapter.toLongArray(TimeIntervalStringValueCollectionTypeAdapter.readBytes("to_ts", reader));
        int[] startPositions = TimeIntervalStringValueCollectionTypeAdapter.toIntArray(TimeIntervalStringValueCollectionTypeAdapter.readBytes("start_position", reader));
        int[] textByteLength = TimeIntervalStringValueCollectionTypeAdapter.toIntArray(TimeIntervalStringValueCollectionTypeAdapter.readBytes("text_byte_length", reader));
        byte[] textDataArray = TimeIntervalStringValueCollectionTypeAdapter.decompress(TimeIntervalStringValueCollectionTypeAdapter.readBytes("text_data_array", reader));
        reader.endObject();
        if (size != fromTsArray.length) {
            throw new IllegalStateException();
        }
        return TimeIntervalStringValueCollection.of(size, fromTsArray, toTsArray, startPositions, textByteLength, textDataArray);
    }

    @Override
    protected void writeNotEmpty(JsonWriter writer, TimeIntervalStringValueCollection t) throws IOException {
        writer.beginObject();
        int size = t.size();
        TimeIntervalStringValueCollectionTypeAdapter.writeValue(writer, "size", size);
        TimeIntervalStringValueCollectionTypeAdapter.writeValue(writer, "from_ts", TimeIntervalStringValueCollectionTypeAdapter.toByteArray(Arrays.copyOf(t.getFromTs(), size)));
        TimeIntervalStringValueCollectionTypeAdapter.writeValue(writer, "to_ts", TimeIntervalStringValueCollectionTypeAdapter.toByteArray(Arrays.copyOf(t.getToTs(), size)));
        TimeIntervalStringValueCollectionTypeAdapter.writeValue(writer, "start_position", TimeIntervalStringValueCollectionTypeAdapter.toByteArray(Arrays.copyOf(t.getStartPosition(), size)));
        TimeIntervalStringValueCollectionTypeAdapter.writeValue(writer, "text_byte_length", TimeIntervalStringValueCollectionTypeAdapter.toByteArray(Arrays.copyOf(t.getTextByteLength(), size)));
        TimeIntervalStringValueCollectionTypeAdapter.writeValue(writer, "text_data_array", TimeIntervalStringValueCollectionTypeAdapter.compress(t.getTextDataArray()));
        writer.endObject();
    }

    private static byte[] compress(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return data;
        }
        LZ4Compressor compressor = compressorFactory.fastCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(data.length);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(data, 0, data.length, compressed, 0, maxCompressedLength);
        byte[] result = new byte[4 + compressedLength];
        ByteBuffer.wrap(result, 0, 4).putInt(data.length);
        System.arraycopy(compressed, 0, result, 4, compressedLength);
        return result;
    }

    private static byte[] decompress(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return data;
        }
        ByteBuffer inputBuffer = ByteBuffer.wrap(data);
        int originalSize = inputBuffer.getInt();
        LZ4FastDecompressor decompressor = compressorFactory.fastDecompressor();
        byte[] restored = new byte[originalSize];
        ByteBuffer outputBuffer = ByteBuffer.wrap(restored);
        try {
            decompressor.decompress(inputBuffer, outputBuffer);
        }
        catch (LZ4Exception exc) {
            logger.error(String.format("Values Cluster decompression error. Bytes: %s", Arrays.toString(data)), (Throwable)exc);
        }
        return restored;
    }
}

