/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.json.typeadapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.json.typeadapters.NotNullValueTypeAdapter;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKey;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceDependency;
import java.io.IOException;

public class VariableInstanceDependencyTypeAdapter
extends NotNullValueTypeAdapter<VariableInstanceDependency> {
    @Override
    public void writeNotEmpty(JsonWriter out, VariableInstanceDependency value) throws IOException {
        out.beginObject();
        VariableInstanceDependencyTypeAdapter.writeValue(out, "instance_id", value.getVariableInstance().getId());
        DependencyKey<?> key = value.getKey();
        out.name("key");
        JsonUtils.GSON.toJson(key, DependencyKey.class, out);
        out.name("dependency");
        switch (key.getType()) {
            case Characteristic2D: {
                JsonUtils.GSON.toJson(value.getDependency(), Characteristic2DInstance.class, out);
                break;
            }
            case LowerLimit: 
            case UpperLimit: 
            case Link: 
            case ExplicitDependency: 
            case VariableReference: {
                JsonUtils.GSON.toJson(value.getDependency(), VariableInstance.class, out);
                break;
            }
            case ObjectProperty: 
            case PropertyReference: {
                JsonUtils.GSON.toJson(value.getDependency(), PropertyValue.class, out);
                break;
            }
            case CustomAlgorithm: {
                out.nullValue();
                break;
            }
        }
        out.endObject();
    }

    @Override
    public VariableInstanceDependency readNotEmpty(JsonReader in) throws IOException {
        in.beginObject();
        VariableInstanceDependency dependency = new VariableInstanceDependency();
        dependency.setVariableInstance(new VariableInstance(VariableInstanceDependencyTypeAdapter.readInt("instance_id", in)));
        VariableInstanceDependencyTypeAdapter.readName("key", in);
        DependencyKey key = (DependencyKey)JsonUtils.GSON.fromJson(in, DependencyKey.class);
        dependency.setKey(key);
        VariableInstanceDependencyTypeAdapter.readName("dependency", in);
        switch (key.getType()) {
            case Characteristic2D: {
                dependency.setDependency(JsonUtils.GSON.fromJson(in, Characteristic2DInstance.class));
                break;
            }
            case LowerLimit: 
            case UpperLimit: 
            case Link: 
            case ExplicitDependency: 
            case VariableReference: {
                dependency.setDependency(JsonUtils.GSON.fromJson(in, VariableInstance.class));
                break;
            }
            case ObjectProperty: 
            case PropertyReference: {
                dependency.setDependency(JsonUtils.GSON.fromJson(in, PropertyValue.class));
                break;
            }
            case CustomAlgorithm: {
                in.nextNull();
                break;
            }
        }
        in.endObject();
        return dependency;
    }
}

