/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.notes;

import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.time.Instant;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_notes_note")
@Access(value=AccessType.PROPERTY)
public class Note
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "notes/note";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"notes/notes.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<NoteType> type = new SimpleObjectProperty((Object)NoteType.Common);
    private final ObjectProperty<Instant> fromTimestamp = new SimpleObjectProperty();
    private final ObjectProperty<Instant> toTimestamp = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();

    public Note() {
    }

    public Note(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_notes_note_sequence")
    @SequenceGenerator(name="ewms_notes_note_sequence", sequenceName="ewms_notes_note_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="type", nullable=false)
    public NoteType getType() {
        return (NoteType)((Object)this.type.get());
    }

    public void setType(NoteType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<NoteType> typeProperty() {
        return this.type;
    }

    @Column(name="from_ts", nullable=false)
    public Instant getFrom() {
        return (Instant)this.fromTimestamp.get();
    }

    public void setFrom(Instant timestamp) {
        this.fromTimestamp.set((Object)timestamp);
    }

    public final ObjectProperty<Instant> fromProperty() {
        return this.fromTimestamp;
    }

    @Column(name="to_ts")
    public Instant getTo() {
        return (Instant)this.toTimestamp.get();
    }

    public void setTo(Instant timestamp) {
        this.toTimestamp.set((Object)timestamp);
    }

    public final ObjectProperty<Instant> toProperty() {
        return this.toTimestamp;
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=false)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    public void setStructureObject(StructureObject structureObject) {
        this.structureObject.set((Object)structureObject);
    }

    public final ObjectProperty<StructureObject> structureObjectProperty() {
        return this.structureObject;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Note.class.hashCode() + 17 * (Integer)this.id.get();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Note) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Note)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getLocalName();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

