/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.notes;

import de.elpro.ewms.core.Messages;
import de.elpro.ui.model.UILabeledElement;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.FontWeight;

public enum NoteType implements UILabeledElement
{
    Internal,
    Common,
    OperationMode,
    Service,
    Repair,
    Failure;


    public Paint getTextFill() {
        switch (this) {
            case Internal: {
                return Color.LIGHTSLATEGRAY;
            }
            case Common: {
                return Color.CORNFLOWERBLUE;
            }
            case OperationMode: {
                return Color.CADETBLUE;
            }
            case Service: {
                return Color.BLUEVIOLET;
            }
            case Repair: {
                return Color.DARKORANGE;
            }
            case Failure: {
                return Color.BROWN;
            }
        }
        return Color.BLACK;
    }

    public FontWeight getFontWeight() {
        return FontWeight.BOLD;
    }

    public String toString() {
        String text = "";
        switch (this) {
            case Internal: {
                text = Messages.notes_NoteType_Internal;
                break;
            }
            case Common: {
                text = Messages.notes_NoteType_Common;
                break;
            }
            case OperationMode: {
                text = Messages.notes_NoteType_OperationMode;
                break;
            }
            case Service: {
                text = Messages.notes_NoteType_Service;
                break;
            }
            case Repair: {
                text = Messages.notes_NoteType_Repair;
                break;
            }
            case Failure: {
                text = Messages.notes_NoteType_Failure;
                break;
            }
        }
        return String.format("%s (%d)", text, this.ordinal());
    }
}

