/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.primitivetypes;

import java.util.Arrays;

public final class ByteString {
    public static final ByteString NULL_VALUE = new ByteString(null);
    private final byte[] bytes;

    public ByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    public ByteString(String string) {
        this.bytes = string.getBytes();
    }

    public int length() {
        return this.bytes != null ? this.bytes.length : 0;
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public boolean isNotNull() {
        return this.bytes != null;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public byte byteAt(int index) {
        if (this.bytes == null) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        return this.bytes[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteString that = (ByteString)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return this.bytes != null ? Arrays.hashCode(this.bytes) : 0;
    }

    public static ByteString of(byte[] bs) {
        return new ByteString(bs);
    }

    public String toString() {
        return Arrays.toString(this.bytes);
    }
}

