/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.rawvalues;

import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.FutureTimeRangeType;
import de.elpro.ewms.core.time.IFutureTimeRange;
import de.elpro.ewms.core.time.Raster;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_rawvaluesview_futuretimerange")
@Access(value=AccessType.PROPERTY)
public class RawValuesViewFutureTimeRange
implements IFutureTimeRange,
Comparable<Object> {
    public static final String DAO_NAMESPACE = "rawvalues/future_time_range";
    private final ObjectProperty<RawValuesViewType> viewType = new SimpleObjectProperty();
    private final ObjectProperty<FutureTimeRangeType> futureType = new SimpleObjectProperty();
    private final ObjectProperty<Raster> futureRangeRaster = new SimpleObjectProperty((Object)Raster.Hour);
    private final ObjectProperty<Integer> futureRangeRasterCount = new SimpleObjectProperty();
    private final ObjectProperty<Long> futureEndTimestamp = new SimpleObjectProperty();
    private final BooleanProperty enabled = new SimpleBooleanProperty(true);

    public RawValuesViewFutureTimeRange() {
    }

    public RawValuesViewFutureTimeRange(RawValuesViewType viewType) {
        this.setViewType(viewType);
    }

    public ObjectProperty<RawValuesViewType> viewTypeProperty() {
        return this.viewType;
    }

    @Id
    @Column(name="view_type")
    public RawValuesViewType getViewType() {
        return (RawValuesViewType)((Object)this.viewTypeProperty().get());
    }

    public void setViewType(RawValuesViewType viewType) {
        this.viewTypeProperty().set((Object)viewType);
    }

    public ObjectProperty<FutureTimeRangeType> futureTypeProperty() {
        return this.futureType;
    }

    @Override
    @Column(name="future_type", nullable=false)
    public FutureTimeRangeType getFutureType() {
        return (FutureTimeRangeType)((Object)this.futureTypeProperty().get());
    }

    public void setFutureType(FutureTimeRangeType futureType) {
        this.futureTypeProperty().set((Object)futureType);
    }

    public ObjectProperty<Raster> futureRangeRasterProperty() {
        return this.futureRangeRaster;
    }

    @Column(name="future_range_raster")
    public Raster getFutureRangeRaster() {
        return (Raster)((Object)this.futureRangeRasterProperty().get());
    }

    public void setFutureRangeRaster(Raster rangeRaster) {
        this.futureRangeRasterProperty().set((Object)rangeRaster);
    }

    public ObjectProperty<Integer> futureRangeRasterCountProperty() {
        return this.futureRangeRasterCount;
    }

    @Column(name="future_range_raster_count")
    public Integer getFutureRangeRasterCount() {
        return (Integer)this.futureRangeRasterCountProperty().get();
    }

    public void setFutureRangeRasterCount(Integer rangeRasterCount) {
        this.futureRangeRasterCountProperty().set((Object)rangeRasterCount);
    }

    @Override
    @Transient
    public Long getFutureRange() {
        if (this.getFutureRangeRaster() != null && this.getFutureRangeRasterCount() != null) {
            return this.getFutureRangeRaster().toMilli() * (long)this.getFutureRangeRasterCount().intValue();
        }
        return null;
    }

    public ObjectProperty<Long> futureEndTimestampProperty() {
        return this.futureEndTimestamp;
    }

    @Override
    @Column(name="future_end_timestamp")
    public Long getFutureEndTimestamp() {
        return (Long)this.futureEndTimestampProperty().get();
    }

    public void setFutureEndTimestamp(Long futureEndTimestamp) {
        this.futureEndTimestampProperty().set((Object)futureEndTimestamp);
    }

    public BooleanProperty enabledProperty() {
        return this.enabled;
    }

    @Override
    @Column(name="enabled")
    public boolean isEnabled() {
        return this.enabledProperty().get();
    }

    public void setEnabled(boolean enabled) {
        this.enabledProperty().set(enabled);
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof RawValuesViewFutureTimeRange) {
            RawValuesViewFutureTimeRange o2 = (RawValuesViewFutureTimeRange)o;
            return this.getViewType().compareTo(o2.getViewType());
        }
        return -1;
    }
}

