/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.report;

import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_report_template", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
@Access(value=AccessType.PROPERTY)
public class ReportTemplate
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "report/template";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/templateprop_co.gif");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<byte[]> data = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();

    public ReportTemplate() {
    }

    public ReportTemplate(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_report_template_sequence")
    @SequenceGenerator(name="ewms_report_template_sequence", sequenceName="ewms_report_template_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="data", nullable=false)
    public byte[] getData() {
        return (byte[])this.data.get();
    }

    public void setData(byte[] data) {
        this.data.set((Object)data);
    }

    public final ObjectProperty<byte[]> dataProperty() {
        return this.data;
    }

    @Column(name="description")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public String toString() {
        return this.getLocalName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReportTemplate)) {
            return false;
        }
        if (this.getId() == null) {
            return super.equals(obj);
        }
        return this.getId().equals(((ReportTemplate)obj).getId());
    }

    public int hashCode() {
        if (this.getId() != null) {
            return ReportTemplate.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }
}

