/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.report;

import de.elpro.ewms.core.report.ReportProfile;
import de.elpro.ewms.core.report.TableReportConfig;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;

@Entity
@javax.persistence.Table(name="ewms_report_table")
@Access(value=AccessType.PROPERTY)
public class TableReport
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "report/table";
    public static final URL DEFAULT_ICON = Table.DEFAULT_ICON;
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<ReportProfile> profile = new SimpleObjectProperty();
    private final ObjectProperty<Table> table = new SimpleObjectProperty();
    private final ObjectProperty<VirtualRaster> virtualRaster = new SimpleObjectProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();
    private List<TableReportConfig> configs = new LinkedList<TableReportConfig>();

    public TableReport() {
    }

    public TableReport(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_report_table_sequence")
    @SequenceGenerator(name="ewms_report_table_sequence", sequenceName="ewms_report_table_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="profile", nullable=false)
    public ReportProfile getProfile() {
        return (ReportProfile)this.profile.get();
    }

    public void setProfile(ReportProfile profile) {
        this.profile.set((Object)profile);
    }

    public final ObjectProperty<ReportProfile> profileProperty() {
        return this.profile;
    }

    @ManyToOne
    @JoinColumn(name="table_id", nullable=false)
    public Table getTable() {
        return (Table)this.table.get();
    }

    public void setTable(Table table) {
        this.table.set((Object)table);
    }

    public final ObjectProperty<Table> tableProperty() {
        return this.table;
    }

    @Column(name="virtual_raster")
    public VirtualRaster getVirtualRaster() {
        return (VirtualRaster)((Object)this.virtualRaster.get());
    }

    public void setVirtualRaster(VirtualRaster virtualRaster) {
        this.virtualRaster.set((Object)virtualRaster);
    }

    public final ObjectProperty<VirtualRaster> virtualRasterProperty() {
        return this.virtualRaster;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @Column(name="description")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @OneToMany(mappedBy="tableReport", cascade={CascadeType.REMOVE})
    public List<TableReportConfig> getConfigs() {
        return this.configs;
    }

    void setConfigs(List<TableReportConfig> configs) {
        this.configs = configs;
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public String toString() {
        return this.getTable().toString();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return TableReport.class.hashCode() + 17 * (Integer)this.id.get();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableReport) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((TableReport)obj).getId())) {
                return true;
            }
        }
        return false;
    }
}

