/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.resources;

import de.elpro.resources.Icons;
import de.elpro.ui.model.UIModelElement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;

public class RDItem
implements UIModelElement {
    private static NumberFormat BYTE_FORMAT = new DecimalFormat("#,##0 'Bytes'");
    private static NumberFormat KB_FORMAT = new DecimalFormat("#,##0 'KB'");
    private static NumberFormat MB_FORMAT = new DecimalFormat("#,##0.0 'MB'");
    private String name;
    private String[] path;
    private Instant lastModified;
    private Long bytes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getPath() {
        return this.path;
    }

    public void setPath(String[] path) {
        this.path = path;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    public Long getBytes() {
        return this.bytes;
    }

    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        return this.getName();
    }

    public String getIconUri() {
        String suffix;
        if (this.getName() == null || !this.getName().contains(".")) {
            return null;
        }
        switch (suffix = this.getName().substring(this.getName().lastIndexOf(46) + 1).toLowerCase()) {
            case "pdf": {
                return Icons.PDF_ITEM_URL.toString();
            }
            case "csv": 
            case "xls": 
            case "sxls": {
                return Icons.EXCEL_ITEM_URL.toString();
            }
        }
        return null;
    }

    public String getFormattedSize() {
        if (this.getBytes() == null) {
            return null;
        }
        if (this.getBytes() >= 1000000L) {
            return MB_FORMAT.format((double)this.getBytes().longValue() / 1048576.0);
        }
        if (this.getBytes() >= 1000L) {
            return KB_FORMAT.format((double)this.getBytes().longValue() / 1000.0);
        }
        return BYTE_FORMAT.format(this.getBytes());
    }
}

