/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.resources;

import de.elpro.ewms.core.Messages;
import de.elpro.ewms.core.resources.ResourceDirectoryType;
import de.elpro.resources.Icons;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_resources_resource_directory")
@Access(value=AccessType.PROPERTY)
public class ResourceDirectory
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "resources/resource_directory";
    public static final URL DEFAULT_ICON = Icons.FOLDER_ITEM_URL;
    private static final String PATH_DELIMITER = "/";
    public static final ResourceDirectory LOCAL_FS = new ResourceDirectory(ResourceDirectoryType.LOCAL_FS, Messages.resources_ResourceDirectory_localfs);
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<ResourceDirectoryType> type = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty remoteAddr = new SimpleStringProperty();
    private final StringProperty remoteConnectionData = new SimpleStringProperty();
    private final StringProperty initialDirectory = new SimpleStringProperty();
    private final StringProperty login = new SimpleStringProperty();
    private final StringProperty password = new SimpleStringProperty();

    public ResourceDirectory() {
    }

    public ResourceDirectory(int id) {
        this();
        this.setId(id);
    }

    public ResourceDirectory(ResourceDirectoryType type, String name) {
        this();
        this.setType(type);
        this.setName(name);
    }

    public ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_resources_resource_directory_sequence")
    @SequenceGenerator(name="ewms_resources_resource_directory_sequence", sequenceName="ewms_resources_resource_directory_sequence")
    public Integer getId() {
        return (Integer)this.idProperty().get();
    }

    void setId(Integer id) {
        this.idProperty().set((Object)id);
    }

    public ObjectProperty<ResourceDirectoryType> typeProperty() {
        return this.type;
    }

    @Column(name="type", nullable=false)
    public ResourceDirectoryType getType() {
        return (ResourceDirectoryType)((Object)this.typeProperty().get());
    }

    public void setType(ResourceDirectoryType type) {
        this.typeProperty().set((Object)type);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.nameProperty().get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public StringProperty remoteAddrProperty() {
        return this.remoteAddr;
    }

    @Column(name="remote_addr")
    public String getRemoteAddr() {
        return (String)this.remoteAddrProperty().get();
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddrProperty().set((Object)remoteAddr);
    }

    public StringProperty remoteConnectionDataProperty() {
        return this.remoteConnectionData;
    }

    @Column(name="remote_connection_data", columnDefinition="TEXT")
    public String getRemoteConnectionData() {
        return (String)this.remoteConnectionDataProperty().get();
    }

    public void setRemoteConnectionData(String remoteConnectionData) {
        this.remoteConnectionDataProperty().set((Object)remoteConnectionData);
    }

    public StringProperty initialDirectoryProperty() {
        return this.initialDirectory;
    }

    @Column(name="initial_directory", columnDefinition="TEXT")
    public String getInitialDirectory() {
        return (String)this.initialDirectoryProperty().get();
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectoryProperty().set((Object)initialDirectory);
    }

    public StringProperty loginProperty() {
        return this.login;
    }

    @Column(name="login")
    public String getLogin() {
        return (String)this.loginProperty().get();
    }

    public void setLogin(String login) {
        this.loginProperty().set((Object)login);
    }

    public StringProperty passwordProperty() {
        return this.password;
    }

    @Column(name="password")
    public String getPassword() {
        return (String)this.passwordProperty().get();
    }

    public void setPassword(String password) {
        this.passwordProperty().set((Object)password);
    }

    @Transient
    public String getBrowsePath(String relativePath) {
        if (relativePath.contains("../") || relativePath.contains("..\\")) {
            return null;
        }
        if (this.getInitialDirectory() != null && !this.getInitialDirectory().isEmpty()) {
            switch (this.getType()) {
                case LOCAL_FS: 
                case SERVER_FS: {
                    return String.valueOf(this.getInitialDirectory()) + PATH_DELIMITER + relativePath;
                }
                case FTPS: 
                case SFTP: {
                    return "./" + this.getInitialDirectory() + PATH_DELIMITER + relativePath;
                }
            }
        } else {
            switch (this.getType()) {
                case LOCAL_FS: 
                case SERVER_FS: {
                    return String.valueOf(this.getInitialDirectory()) + PATH_DELIMITER + relativePath;
                }
                case FTPS: 
                case SFTP: {
                    return "./" + relativePath;
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.getLocalName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceDirectory)) {
            return false;
        }
        if (this.getId() == null) {
            return super.equals(obj);
        }
        return this.getId().equals(((ResourceDirectory)obj).getId());
    }

    public int hashCode() {
        if (this.getId() != null) {
            return ResourceDirectory.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

