/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.resources;

import de.elpro.ewms.core.bundle.Activator;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javafx.util.Pair;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.core.log.Logger;

public class ResourceLoader {
    private static final Logger logger = Activator.createLogger(ResourceLoader.class);
    private static final IPath CACHE_FOLDER = Activator.getWorkspaceLocation().append("cache/icons/");
    private static final Map<String, Pair<String, Instant>> CACHED_ICONS = new HashMap<String, Pair<String, Instant>>();
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static Lock readLock = readWriteLock.readLock();
    private static Lock writeLock = readWriteLock.writeLock();
    private static ResourceLoaderCallback loaderCallback;

    public static void init(ResourceLoaderCallback loaderCallback) {
        ResourceLoader.loaderCallback = loaderCallback;
    }

    public static String getCachedIconPath(String iconKey) {
        if (iconKey == null) {
            return null;
        }
        readLock.lock();
        try {
            Pair<String, Instant> cachedPath = CACHED_ICONS.get(iconKey);
            if (cachedPath != null && ((Instant)cachedPath.getValue()).plusSeconds(600L).isAfter(Instant.now())) {
                String string = (String)cachedPath.getKey();
                return string;
            }
        }
        finally {
            readLock.unlock();
        }
        writeLock.lock();
        try {
            ResourceLoader.cacheIcon(ResourceLoader.getScallingKey(1, iconKey));
            ResourceLoader.cacheIcon(ResourceLoader.getScallingKey(2, iconKey));
            String path = "file:" + CACHE_FOLDER.append(iconKey).toString();
            CACHED_ICONS.put(iconKey, (Pair<String, Instant>)new Pair((Object)path, (Object)Instant.now()));
            String string = path;
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    private static void cacheIcon(String iconKey) {
        try {
            InputStream in;
            File file = new File(CACHE_FOLDER.append(iconKey).toString());
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            if ((in = loaderCallback.getIconInputStream(iconKey)) == null) {
                return;
            }
            try {
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            logger.errorf("Error caching icon for %s", (Throwable)e, new Object[]{iconKey});
        }
    }

    private static String getScallingKey(int scalling, String key) {
        if (scalling == 1) {
            return key;
        }
        return key.replace(".", String.format("@%dx.", scalling));
    }

    public static interface ResourceLoaderCallback {
        public InputStream getIconInputStream(String var1);
    }
}

