/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.schedules;

import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.time.LocalDateTime;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_schedules_schedule")
@Access(value=AccessType.PROPERTY)
public class Schedule
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "schedules/schedule";
    public static final URL DEFAULT_ICON_URL = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/server_schedules.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty jobId = new SimpleStringProperty();
    private final ObjectProperty<LocalDateTime> jobBegin = new SimpleObjectProperty();
    private final ObjectProperty<LocalDateTime> jobEnd = new SimpleObjectProperty();
    private final ObjectProperty<ComplexRaster> executionInterval = new SimpleObjectProperty();
    private final StringProperty options = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final BooleanProperty active = new SimpleBooleanProperty(true);
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();

    public Schedule() {
    }

    public Schedule(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_schedules_schedule_sequence")
    @SequenceGenerator(name="ewms_schedules_schedule_sequence", sequenceName="ewms_schedules_schedule_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="job_id", nullable=false)
    public String getJobId() {
        return (String)this.jobId.get();
    }

    public void setJobId(String id) {
        this.jobId.set((Object)id);
    }

    public final StringProperty jobIdProperty() {
        return this.jobId;
    }

    @Column(name="job_begin", nullable=false)
    public LocalDateTime getJobBegin() {
        return (LocalDateTime)this.jobBegin.get();
    }

    public void setJobBegin(LocalDateTime jobBegin) {
        this.jobBegin.set((Object)jobBegin);
    }

    public final ObjectProperty<LocalDateTime> jobBeginProperty() {
        return this.jobBegin;
    }

    @Column(name="job_end")
    public LocalDateTime getJobEnd() {
        return (LocalDateTime)this.jobEnd.get();
    }

    public void setJobEnd(LocalDateTime jobEnd) {
        this.jobEnd.set((Object)jobEnd);
    }

    public final ObjectProperty<LocalDateTime> jobEndProperty() {
        return this.jobEnd;
    }

    @Column(name="execution_interval_name", nullable=false)
    public ComplexRaster getExecutionInterval() {
        return (ComplexRaster)this.executionInterval.get();
    }

    public void setExecutionInterval(ComplexRaster executionInterval) {
        this.executionInterval.set((Object)executionInterval);
    }

    public final ObjectProperty<ComplexRaster> executionIntervalProperty() {
        return this.executionInterval;
    }

    @Column(name="options", columnDefinition="TEXT")
    public String getOptions() {
        return (String)this.options.get();
    }

    public void setOptions(String options) {
        this.options.set((Object)options);
    }

    public final StringProperty optionsProperty() {
        return this.options;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    public final BooleanProperty activeProperty() {
        return this.active;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    public String toString() {
        return this.getName();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON_URL.toString();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Schedule.class.hashCode() + 17 * this.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule o = (Schedule)obj;
        if (this.getId() != null) {
            return this.getId().equals(o.getId());
        }
        return super.equals(obj);
    }
}

