/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyTypes;
import de.elpro.ewms.core.structure.StructureObject;
import java.io.Serializable;
import java.time.Instant;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_structure_property_value")
@Access(value=AccessType.PROPERTY)
public class PropertyValue
implements Serializable {
    public static final String DAO_NAMESPACE = "structure/property_value";
    private static final long serialVersionUID = 6267129455593957528L;
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final ObjectProperty<Property> property = new SimpleObjectProperty();
    private final StringProperty value = new SimpleStringProperty();
    private final ObjectProperty<User> user = new SimpleObjectProperty();
    private final ObjectProperty<Instant> timestamp = new SimpleObjectProperty();

    protected PropertyValue() {
    }

    public PropertyValue(StructureObject structureObject, Property property) {
        this(structureObject, property, null);
    }

    public PropertyValue(StructureObject structureObject, Property property, String value) {
        this.setStructureObject(structureObject);
        this.setProperty(property);
        this.setValue(value);
    }

    @Id
    @ManyToOne
    @JoinColumn(name="structure_object")
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    protected void setStructureObject(StructureObject structureObject) {
        this.structureObject.set((Object)structureObject);
    }

    @Id
    @ManyToOne
    @JoinColumn(name="property")
    public Property getProperty() {
        return (Property)this.property.get();
    }

    protected void setProperty(Property property) {
        this.property.set((Object)property);
    }

    @Column(name="value", columnDefinition="TEXT", nullable=false)
    public String getValue() {
        return (String)this.value.get();
    }

    public void setValue(String value) {
        this.value.set((Object)value);
    }

    public final StringProperty valueProperty() {
        return this.value;
    }

    @Transient
    public <T> T getTypeValue() {
        IPropertyType type = PropertyTypes.getPropertyType(this.getProperty().getTypeId());
        return (T)type.getValueConverter().fromString(this.getValue());
    }

    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    public User getUser() {
        return (User)this.user.get();
    }

    public void setUser(User user) {
        this.user.set((Object)user);
    }

    public final ObjectProperty<User> userProperty() {
        return this.user;
    }

    @Column(name="timestamp", nullable=false)
    public Instant getTimestamp() {
        return (Instant)this.timestamp.get();
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp.set((Object)timestamp);
    }

    public final ObjectProperty<Instant> timestampProperty() {
        return this.timestamp;
    }

    public String toString() {
        return this.getProperty() + "=" + this.getValue();
    }

    public int hashCode() {
        return PropertyValue.class.hashCode() + 17 * this.getStructureObject().hashCode() + 7 * this.getProperty().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyValue)) {
            return false;
        }
        PropertyValue otherPV = (PropertyValue)obj;
        return this.getStructureObject().equals(otherPV.getStructureObject()) && this.getProperty().equals(otherPV.getProperty());
    }
}

