/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure;

import de.elpro.ewms.core.Messages;
import de.elpro.ui.model.ComparableEnum;

public enum SearchPolicy implements ComparableEnum
{
    Auto(0),
    Parent(1),
    Children(2),
    ThisOrParent(6),
    ThisOrChildren(7),
    This(5),
    DirectChildren(3),
    TopChildren(4),
    All(8);

    private final int sortOrder;

    private SearchPolicy(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean canSearchAtSameLevel() {
        switch (this) {
            case Auto: 
            case ThisOrParent: 
            case ThisOrChildren: 
            case This: {
                return true;
            }
        }
        return false;
    }

    public boolean canSearchAtParentLevel() {
        switch (this) {
            case Auto: 
            case Parent: 
            case ThisOrParent: {
                return true;
            }
        }
        return false;
    }

    public boolean canSearchAtSubLevel() {
        switch (this) {
            case Auto: 
            case Children: 
            case ThisOrChildren: 
            case TopChildren: {
                return true;
            }
        }
        return false;
    }

    public boolean stopIfFound() {
        switch (this) {
            case Auto: 
            case Parent: 
            case TopChildren: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        switch (this) {
            case Auto: {
                return Messages.structure_SearchPolicy_default;
            }
            case All: {
                return Messages.structure_SearchPolicy_all;
            }
            case Parent: {
                return Messages.structure_SearchPolicy_parent;
            }
            case Children: {
                return Messages.structure_SearchPolicy_children;
            }
            case ThisOrParent: {
                return Messages.structure_SearchPolicy_thisorparent;
            }
            case ThisOrChildren: {
                return Messages.structure_SearchPolicy_thisorchildren;
            }
            case TopChildren: {
                return Messages.structure_SearchPolicy_topchildren;
            }
            case This: {
                return Messages.structure_SearchPolicy_this;
            }
            case DirectChildren: {
                return Messages.structure_SearchPolicy_directchildren;
            }
        }
        return this.name();
    }

    public int getSortOrder() {
        return this.sortOrder;
    }
}

