/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure;

import de.elpro.ewms.core.Messages;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.json.JsonElement;
import de.elpro.ewms.core.resources.ResourceLoader;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_structure_object", uniqueConstraints={@UniqueConstraint(columnNames={"structure_class", "name", "object_key"})})
@Access(value=AccessType.PROPERTY)
public class StructureObject
implements UIModelElement,
IdObject,
JsonElement {
    public static final String DAO_NAMESPACE = "structure/object";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/structure_object.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty key = new SimpleStringProperty();
    private final ObjectProperty<Instant> installed = new SimpleObjectProperty();
    private final ObjectProperty<Instant> removed = new SimpleObjectProperty();
    private final ObjectProperty<Color> defaultColor = new SimpleObjectProperty();
    private final StringProperty plcAliasMapText = new SimpleStringProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private Set<StructureObject> children = new LinkedHashSet<StructureObject>();
    private Set<StructureObject> parents = new LinkedHashSet<StructureObject>();
    private Set<VariableInstance> variableInstances = new LinkedHashSet<VariableInstance>();
    private Set<Characteristic2DInstance> characteristic2DInstances = new LinkedHashSet<Characteristic2DInstance>();
    private Set<Characteristic3DInstance> characteristic3DInstances = new LinkedHashSet<Characteristic3DInstance>();
    private Set<PropertyValue> propertyValues = new LinkedHashSet<PropertyValue>();
    private String resultIconKey;

    public StructureObject() {
    }

    public StructureObject(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_structure_object_sequence")
    @SequenceGenerator(name="ewms_structure_object_sequence", sequenceName="ewms_structure_object_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="object_key")
    public String getKey() {
        return (String)this.key.get();
    }

    public void setKey(String key) {
        this.key.set((Object)key);
    }

    public final StringProperty keyProperty() {
        return this.key;
    }

    @Transient
    public String getTextIdentifier() {
        if (this.getKey() != null && !this.getKey().isEmpty()) {
            return this.getKey();
        }
        return String.format("object_id_%d", this.getId());
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public ObjectProperty<Instant> installedProperty() {
        return this.installed;
    }

    @Column(name="installed")
    public Instant getInstalled() {
        return (Instant)this.installedProperty().get();
    }

    public void setInstalled(Instant installed) {
        this.installedProperty().set((Object)installed);
    }

    public ObjectProperty<Instant> removedProperty() {
        return this.removed;
    }

    @Column(name="removed")
    public Instant getRemoved() {
        return (Instant)this.removedProperty().get();
    }

    public void setRemoved(Instant removed) {
        this.removedProperty().set((Object)removed);
    }

    public boolean isPresent(Instant at) {
        if (at == null) {
            throw new IllegalArgumentException();
        }
        Instant installed = this.getInstalled();
        Instant removed = this.getRemoved();
        if (installed == null && removed == null) {
            return true;
        }
        if (installed == null) {
            return !at.isAfter(removed);
        }
        if (removed == null) {
            return !at.isBefore(installed);
        }
        return !at.isBefore(installed) && !at.isAfter(removed);
    }

    @Transient
    public TsInterval getPresenceInterval() {
        return new TsInterval(this.getInstalled() != null ? this.getInstalled().toEpochMilli() : 0L, this.getRemoved() != null ? this.getRemoved().toEpochMilli() : Long.MAX_VALUE);
    }

    @Column(name="default_color")
    public Color getDefaultColor() {
        return (Color)this.defaultColor.get();
    }

    public void setDefaultColor(Color color) {
        this.defaultColor.set((Object)color);
    }

    public final ObjectProperty<Color> defaultColorProperty() {
        return this.defaultColor;
    }

    @Column(name="plc_alias_map_text", columnDefinition="TEXT")
    public String getPlcAliasMapText() {
        return (String)this.plcAliasMapText.get();
    }

    public void setPlcAliasMapText(String plcAliasMapText) {
        this.plcAliasMapText.set((Object)plcAliasMapText);
    }

    public final StringProperty plcAliasMapTextProperty() {
        return this.plcAliasMapText;
    }

    @Transient
    public Map<String, String> getPlcAliasMap() {
        String[] aliases;
        String plcAliasMapText = this.getPlcAliasMapText();
        if (plcAliasMapText == null || plcAliasMapText.trim().isEmpty()) {
            return null;
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        String[] stringArray = aliases = plcAliasMapText.split(";");
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            String[] aliasParts = alias.split("=");
            if (aliasParts.length == 2) {
                String aliasKey = aliasParts[0].trim();
                String aliasValue = aliasParts[1].trim();
                aliasMap.put(aliasKey, aliasValue);
            }
            ++n2;
        }
        return aliasMap;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @ManyToMany
    @JoinTable(name="ewms_structure_object_children", joinColumns={@JoinColumn(name="parentobject")}, inverseJoinColumns={@JoinColumn(name="childobject")})
    public Set<StructureObject> getChildren() {
        return this.children;
    }

    protected void setChildren(Set<StructureObject> children) {
        this.children = children;
    }

    @Transient
    public Set<StructureObject> getAllChildren() {
        HashSet<StructureObject> allChildren = new HashSet<StructureObject>();
        allChildren.add(this);
        for (StructureObject child : this.getChildren()) {
            for (StructureObject cchild : child.getAllChildren()) {
                if (allChildren.contains(cchild)) continue;
                allChildren.add(cchild);
            }
            if (allChildren.contains(child)) continue;
            allChildren.add(child);
        }
        return allChildren;
    }

    @ManyToMany
    @JoinTable(name="ewms_structure_object_children", joinColumns={@JoinColumn(name="childobject")}, inverseJoinColumns={@JoinColumn(name="parentobject")})
    public Set<StructureObject> getParents() {
        return this.parents;
    }

    protected void setParents(Set<StructureObject> parents) {
        this.parents = parents;
    }

    @Transient
    public Set<StructureObject> getAllParents() {
        HashSet<StructureObject> allParents = new HashSet<StructureObject>();
        allParents.add(this);
        for (StructureObject parent : this.getParents()) {
            for (StructureObject pparent : parent.getAllParents()) {
                if (allParents.contains(pparent)) continue;
                allParents.add(pparent);
            }
            if (allParents.contains(parent)) continue;
            allParents.add(parent);
        }
        return allParents;
    }

    @Transient
    public Set<StructureObject> getRootParents() {
        HashSet<StructureObject> rootParents = new HashSet<StructureObject>();
        LinkedList<StructureObject> candidates = new LinkedList<StructureObject>(this.getParents());
        HashSet<StructureObject> visited = new HashSet<StructureObject>();
        while (!candidates.isEmpty()) {
            StructureObject candidate = candidates.removeFirst();
            if (candidate.getParents().isEmpty()) {
                rootParents.add(candidate);
            } else {
                for (StructureObject candidateParent : candidate.getParents()) {
                    if (visited.contains(candidateParent)) continue;
                    candidates.add(candidateParent);
                }
            }
            visited.add(candidate);
        }
        return rootParents;
    }

    @OneToMany(mappedBy="structureObject")
    public Set<VariableInstance> getVariableInstances() {
        return this.variableInstances;
    }

    protected void setVariableInstances(Set<VariableInstance> variables) {
        this.variableInstances = variables;
    }

    public VariableInstance findVariableInstance(Variable variable) {
        for (VariableInstance instance : this.getVariableInstances()) {
            if (!instance.getVariable().equals(variable)) continue;
            return instance;
        }
        return null;
    }

    @OneToMany(mappedBy="structureObject")
    public Set<Characteristic2DInstance> getCharacteristic2DInstances() {
        return this.characteristic2DInstances;
    }

    protected void setCharacteristic2DInstances(Set<Characteristic2DInstance> instances) {
        this.characteristic2DInstances = instances;
    }

    public Characteristic2DInstance findCharacteristic2DInstance(Characteristic2D characteristic) {
        for (Characteristic2DInstance instance : this.getCharacteristic2DInstances()) {
            if (!instance.getCharacteristic().equals(characteristic)) continue;
            return instance;
        }
        return null;
    }

    @OneToMany(mappedBy="structureObject")
    public Set<Characteristic3DInstance> getCharacteristic3DInstances() {
        return this.characteristic3DInstances;
    }

    protected void setCharacteristic3DInstances(Set<Characteristic3DInstance> instances) {
        this.characteristic3DInstances = instances;
    }

    public Characteristic3DInstance findCharacteristic3DInstance(Characteristic3D characteristic) {
        for (Characteristic3DInstance instance : this.getCharacteristic3DInstances()) {
            if (!instance.getCharacteristic().equals(characteristic)) continue;
            return instance;
        }
        return null;
    }

    @OneToMany(mappedBy="structureObject", cascade={CascadeType.REMOVE})
    public Set<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    protected void setPropertyValues(Set<PropertyValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    @Transient
    public PropertyValue getPropertyValue(Property property) {
        for (PropertyValue propertyValue : this.propertyValues) {
            if (!propertyValue.getProperty().equals(property)) continue;
            return propertyValue;
        }
        return null;
    }

    @Transient
    public PropertyValue getPropertyValue(String groupKey, String propertyKey) {
        for (PropertyValue propertyValue : this.propertyValues) {
            Property property = propertyValue.getProperty();
            if (!property.getGroup().getKey().equals(groupKey) || !property.getKey().equals(propertyKey)) continue;
            return propertyValue;
        }
        return null;
    }

    @Transient
    public boolean getConnectionIsAllowed(StructureObject targetObject) {
        for (StructureClass allowedClass : this.getStructureClass().getAllConnectedClasses()) {
            if (!targetObject.getStructureClass().isSubclass(allowedClass)) continue;
            return true;
        }
        return false;
    }

    public void loadResultIconKey() {
        if (this.getStructureClass() != null) {
            if (this.getStructureClass().getResultIconKey() == null) {
                this.getStructureClass().loadResultIconKey();
            }
            this.resultIconKey = this.getStructureClass().getResultIconKey();
        }
    }

    @Transient
    public String getResultIconKey() {
        return this.resultIconKey;
    }

    public void setResultIconKey(String resultIconKey) {
        this.resultIconKey = resultIconKey;
    }

    public String toString() {
        String text = this.getLocalName();
        if (text == null) {
            return Messages.StructureObject_text_noname;
        }
        return text;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StructureObject)) {
            return false;
        }
        StructureObject o = (StructureObject)obj;
        if (this.getId() != null) {
            return this.getId().equals(o.getId());
        }
        return this == obj;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return StructureObject.class.hashCode() + 17 * this.getId();
    }

    @Transient
    public String getIconUri() {
        if (this.getResultIconKey() != null) {
            return ResourceLoader.getCachedIconPath(this.getResultIconKey());
        }
        return DEFAULT_ICON.toString();
    }

    @Override
    public void beforeWriteToJson() {
        this.loadResultIconKey();
    }
}

