/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure.propertytypes;

import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitValue;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.util.StringConverter;
import jidefx.scene.control.validation.Validator;
import org.osgi.service.component.annotations.Component;

@Component(service={IPropertyType.class})
public class BooleanPropertyType
implements IPropertyType<MeasuringUnitValue, Void> {
    public static final String ID = "de.elpro.ewms.core.structure.propertytypes.boolean";
    public static final StringConverter<MeasuringUnitValue> CONVERTER = new StringConverter<MeasuringUnitValue>(){

        public String toString(MeasuringUnitValue object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        public MeasuringUnitValue fromString(String string) {
            if (string == null) {
                return null;
            }
            return MeasuringUnitValue.parse(string);
        }
    };

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Boolean";
    }

    @Override
    public StringConverter<MeasuringUnitValue> getValueConverter() {
        return CONVERTER;
    }

    @Override
    public StringConverter<Void> getParameterConverter() {
        return null;
    }

    @Override
    public Node createValueEditor(Property<MeasuringUnitValue> valueProperty, Void parameter, ObservableBooleanValue editableProperty) {
        CheckBox checkBox = new CheckBox();
        checkBox.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)editableProperty));
        MeasuringUnitValue val = (MeasuringUnitValue)valueProperty.getValue();
        checkBox.setSelected(val != null && val.getValue() == 1.0);
        checkBox.selectedProperty().addListener((o, ov, nv) -> {
            MeasuringUnitValue mv = new MeasuringUnitValue(MeasuringUnit.getMeasuringUnit("number / dimensionless"), nv != false ? 1 : 0);
            valueProperty.setValue((Object)mv);
        });
        return checkBox;
    }

    @Override
    public Node createParameterEditor(Property<Void> parameterProperty) {
        return null;
    }

    @Override
    public Validator getValueValidator() {
        return null;
    }

    @Override
    public Validator getParameterValidator() {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

