/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.structure.propertytypes;

import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ui.fx.controls.LocaleTextField;
import de.elpro.ui.text.LocaleText;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.util.StringConverter;
import jidefx.scene.control.validation.Validator;
import org.osgi.service.component.annotations.Component;

@Component(service={IPropertyType.class})
public class LocaleTextPropertyType
implements IPropertyType<LocaleText, Void> {
    public static final String ID = "de.elpro.ewms.core.structure.propertytypes.localetext";
    public static final StringConverter<LocaleText> CONVERTER = new StringConverter<LocaleText>(){

        public String toString(LocaleText object) {
            if (object == null) {
                return null;
            }
            return object.toJson();
        }

        public LocaleText fromString(String string) {
            if (string == null) {
                return null;
            }
            return LocaleText.tryParse((Locale)Locale.getDefault(), (String)string);
        }
    };

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Locale Text";
    }

    @Override
    public StringConverter<LocaleText> getValueConverter() {
        return CONVERTER;
    }

    @Override
    public StringConverter<Void> getParameterConverter() {
        return null;
    }

    @Override
    public Node createValueEditor(Property<LocaleText> valueProperty, Void parameter, ObservableBooleanValue editableProperty) {
        LocaleTextField textField = new LocaleTextField();
        textField.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)editableProperty));
        textField.setValue((LocaleText)valueProperty.getValue());
        textField.valueProperty().addListener((o, ov, nv) -> valueProperty.setValue(nv));
        return textField;
    }

    @Override
    public Node createParameterEditor(Property<Void> parameterProperty) {
        return null;
    }

    @Override
    public Validator getValueValidator() {
        return null;
    }

    @Override
    public Validator getParameterValidator() {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

