/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.tables;

import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.tables.ColumnStyle;
import de.elpro.ewms.core.tables.ColumnStyleScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TableStyle {
    private final TreeSet<ColumnStyle> columnStyles = new TreeSet();

    public TableStyle() {
    }

    public TableStyle(Collection<ColumnStyle> styles) {
        this.columnStyles.addAll(styles);
    }

    public ColumnStyle getColumnStyle(String styleClassName) {
        for (ColumnStyle style : this.columnStyles) {
            if (!style.getStyleClassName().equals(styleClassName)) continue;
            return style;
        }
        return null;
    }

    public Collection<ColumnStyle> getColumnStyles() {
        return this.columnStyles;
    }

    public void addColumnStyle(ColumnStyle style) {
        this.columnStyles.add(style);
    }

    public void removeColumnStyle(ColumnStyle style) {
        this.columnStyles.remove(style);
    }

    public Set<String> getStyleClassNames() {
        return this.columnStyles.stream().map(c -> c.getStyleClassName()).collect(Collectors.toSet());
    }

    public String toJson() {
        return JsonUtils.GSON.toJson((Object)this);
    }

    public static TableStyle parse(String json) {
        if (json == null || json.isBlank()) {
            return null;
        }
        return (TableStyle)JsonUtils.GSON.fromJson(json, TableStyle.class);
    }

    public String toStylesheet() {
        StringBuilder stylesheet = new StringBuilder();
        this.columnStyles.forEach(c -> {
            StringBuilder stringBuilder2 = stylesheet.append(c.toStylesheet());
        });
        return stylesheet.toString();
    }

    public Collection<String> getStyleClassNames(ColumnStyleScope ... scopes) {
        ArrayList<String> names = new ArrayList<String>();
        HashSet<ColumnStyleScope> scopesSet = new HashSet<ColumnStyleScope>();
        ColumnStyleScope[] columnStyleScopeArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnStyleScope scope = columnStyleScopeArray[n2];
            scopesSet.add(scope);
            ++n2;
        }
        for (ColumnStyle style : this.columnStyles) {
            if (style.getScope() == null || !scopesSet.contains((Object)style.getScope()) || style.getStyleClassName() == null || style.getStyleClassName().isBlank()) continue;
            names.add(style.getStyleClassName());
        }
        return names;
    }
}

