/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.tables.viewprefs;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.prefs.IViewPrefs;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.model.IdObject;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@javax.persistence.Table(name="ewms_tables_viewprefs_table", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "var_table", "structure_object"})})
@Access(value=AccessType.PROPERTY)
public class TableViewPrefs
implements IViewPrefs,
IdObject {
    public static final String DAO_NAMESPACE = "tables/table_view_prefs";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Table> table = new SimpleObjectProperty();
    private final ObjectProperty<User> user = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final ObjectProperty<TimeRangeFilterType> timeRangeFilterType = new SimpleObjectProperty();
    private final ObjectProperty<Integer> customViewIndex = new SimpleObjectProperty();
    private final ObjectProperty<Raster> raster = new SimpleObjectProperty();
    private final ObjectProperty<VirtualRaster> virtualRaster = new SimpleObjectProperty();
    private String columnsPersistedState = null;

    TableViewPrefs() {
    }

    public TableViewPrefs(int id) {
        this.setId(id);
    }

    public TableViewPrefs(int id, Table tableConfig, StructureObject structureObject) {
        this(tableConfig, structureObject);
        this.setId(id);
    }

    public TableViewPrefs(Table tableConfig, StructureObject structureObject) {
        this.setTable(tableConfig);
        this.setStructureObject(structureObject);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_tables_viewprefs_table_sequence")
    @SequenceGenerator(name="ewms_tables_viewprefs_table_sequence", sequenceName="ewms_tables_viewprefs_table_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(int id) {
        this.id.set((Object)id);
    }

    @ManyToOne
    @JoinColumn(name="var_table", nullable=false)
    public Table getTable() {
        return (Table)this.table.get();
    }

    public void setTable(Table table) {
        this.table.set((Object)table);
    }

    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    public User getUser() {
        return (User)this.user.get();
    }

    public void setUser(User user) {
        this.user.set((Object)user);
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=true)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    public void setStructureObject(StructureObject object) {
        this.structureObject.set((Object)object);
    }

    public ObjectProperty<TimeRangeFilterType> timeRangeFilterTypeProperty() {
        return this.timeRangeFilterType;
    }

    @Override
    @Column(name="time_range_filter_type")
    public TimeRangeFilterType getTimeRangeFilterType() {
        return (TimeRangeFilterType)((Object)this.timeRangeFilterTypeProperty().get());
    }

    @Override
    public void setTimeRangeFilterType(TimeRangeFilterType timeRangeFilterType) {
        this.timeRangeFilterTypeProperty().set((Object)timeRangeFilterType);
    }

    public ObjectProperty<Integer> customViewIndexProperty() {
        return this.customViewIndex;
    }

    @Override
    @Column(name="custom_view_index")
    public Integer getCustomViewIndex() {
        return (Integer)this.customViewIndexProperty().get();
    }

    @Override
    public void setCustomViewIndex(Integer index) {
        this.customViewIndexProperty().set((Object)index);
    }

    @Override
    @Column(name="raster")
    public Raster getRaster() {
        return (Raster)((Object)this.rasterProperty().get());
    }

    @Override
    public void setRaster(Raster raster) {
        this.rasterProperty().set((Object)raster);
    }

    public final ObjectProperty<Raster> rasterProperty() {
        return this.raster;
    }

    @Override
    @Column(name="virtual_raster")
    public VirtualRaster getVirtualRaster() {
        return (VirtualRaster)((Object)this.virtualRasterProperty().get());
    }

    @Override
    public void setVirtualRaster(VirtualRaster virtualRaster) {
        this.virtualRasterProperty().set((Object)virtualRaster);
    }

    public final ObjectProperty<VirtualRaster> virtualRasterProperty() {
        return this.virtualRaster;
    }

    @Override
    @Transient
    public ComplexRaster getComplexRaster() {
        if (this.getVirtualRaster() != null) {
            return ComplexRaster.of(this.getVirtualRaster());
        }
        if (this.getRaster() != null) {
            return ComplexRaster.of(this.getRaster());
        }
        return null;
    }

    @Column(name="column_persisted_state", columnDefinition="TEXT")
    public String getColumnsPersistedState() {
        return this.columnsPersistedState;
    }

    public void setColumnsPersistedState(String columnsPersistedState) {
        this.columnsPersistedState = columnsPersistedState;
    }
}

