/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_timeline_phase_type", uniqueConstraints={@UniqueConstraint(columnNames={"timeline", "key"})})
@Access(value=AccessType.PROPERTY)
public class PhaseType
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "phase_type";
    private ObjectProperty<Integer> id = new SimpleObjectProperty();
    private ObjectProperty<Timeline> timeline = new SimpleObjectProperty();
    private StringProperty key = new SimpleStringProperty();
    private StringProperty name = new SimpleStringProperty();
    private StringProperty description = new SimpleStringProperty();
    private ObjectProperty<Color> chartColor = new SimpleObjectProperty();
    private ObjectProperty<ShapeType> chartShapeType = new SimpleObjectProperty();

    public PhaseType() {
    }

    public PhaseType(int id) {
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_timeline_phase_type_sequence")
    @SequenceGenerator(name="ewms_timeline_phase_type_sequence", sequenceName="ewms_timeline_phase_type_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="timeline")
    public Timeline getTimeline() {
        return (Timeline)this.timeline.get();
    }

    public void setTimeline(Timeline timeline) {
        this.timeline.set((Object)timeline);
    }

    public ObjectProperty<Timeline> timelineProperty() {
        return this.timeline;
    }

    @Column(name="key")
    public String getKey() {
        return (String)this.key.get();
    }

    public void setKey(String key) {
        this.key.set((Object)key);
    }

    public StringProperty keyProperty() {
        return this.key;
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    @Column(name="name", nullable=false)
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    @Column(name="chart_color")
    public Color getChartColor() {
        return (Color)this.chartColor.get();
    }

    public void setChartColor(Color chartColor) {
        this.chartColor.set((Object)chartColor);
    }

    public ObjectProperty<Color> chartColorProperty() {
        return this.chartColor;
    }

    @Column(name="chart_shape_type")
    public ShapeType getChartShapeType() {
        return (ShapeType)((Object)this.chartShapeType.get());
    }

    public void setChartShapeType(ShapeType shapeType) {
        this.chartShapeType.set((Object)shapeType);
    }

    public ObjectProperty<ShapeType> chartShapeTypeProperty() {
        return this.chartShapeType;
    }

    @Transient
    public String getIconUri() {
        return null;
    }

    public String toString() {
        return this.getLocalName();
    }

    @Transient
    public Node getGraphic() {
        if (this.getChartShapeType() == null) {
            return new Rectangle(10.0, 10.0, (Paint)this.getChartColor());
        }
        return this.getChartShapeType().createFXShape(10.0, (Paint)Color.BLACK, (Paint)this.getChartColor());
    }

    public int hashCode() {
        return PhaseType.class.hashCode() + 17 * this.getKey().hashCode() * 17 * 17 * this.getTimeline().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PhaseType)) {
            return false;
        }
        PhaseType pt = (PhaseType)obj;
        return this.getTimeline().equals(pt.getTimeline()) && this.getKey().equals(pt.getKey());
    }
}

