/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.time;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.core.virtualtime.ZoneIdWithOffset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TsIntervals {
    private ArrayList<TsInterval> intervals = new ArrayList();

    public void addInterval(TsInterval interval) {
        this.addInterval(interval.getFromTs(), interval.getToTs());
    }

    public void addInterval(Instant from, Instant to) {
        this.addInterval(from.toEpochMilli(), to.toEpochMilli());
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void addInterval(long fromTs, long toTs) {
        i = 0;
        if (!this.intervals.isEmpty()) ** GOTO lbl24
        this.intervals.add(new TsInterval(fromTs, toTs));
        return;
lbl-1000:
        // 1 sources

        {
            interval = this.intervals.get(i);
            if (toTs < interval.getFromTs()) {
                this.intervals.add(i, new TsInterval(fromTs, toTs));
                return;
            }
            if (interval.getToTs() < fromTs) {
                if (++i < this.intervals.size()) continue;
                this.intervals.add(new TsInterval(fromTs, toTs));
                return;
            }
            interval.merge(fromTs, toTs);
            while (i + 1 < this.intervals.size()) {
                nextInterval = this.intervals.get(i + 1);
                if (interval.getIntersectDuration(nextInterval) < 0L) break;
                interval.merge(nextInterval.getFromTs(), nextInterval.getToTs());
                this.intervals.remove(i + 1);
            }
            return;
lbl24:
            // 2 sources

            ** while (i < this.intervals.size())
        }
lbl25:
        // 1 sources

    }

    public Collection<TsInterval> getIntervals() {
        return this.intervals;
    }

    public boolean hasIntersections(long fromTs, long toTs) {
        for (TsInterval interval : this.getIntervals()) {
            if (interval.getIntersectDuration(fromTs, toTs) <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean containsInterval(long fromTs, long toTs) {
        for (TsInterval interval : this.getIntervals()) {
            if (interval.getFromTs() > fromTs || interval.getToTs() < toTs) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public TsIntervals[] split(ComplexRaster sliceSize) {
        if (ComplexRaster.OVERALL.equals(sliceSize)) {
            return new TsIntervals[]{this.copy()};
        }
        ArrayList<TsIntervals> slices = new ArrayList<TsIntervals>();
        Instant currentSliceBegin = null;
        TsIntervals intervals = null;
        for (TsInterval interval : this.getIntervals()) {
            Instant intervalBegin = Instant.ofEpochMilli(interval.getFromTs()).plusNanos(1L);
            Instant intervalEnd = Instant.ofEpochMilli(interval.getToTs());
            if (currentSliceBegin == null) {
                currentSliceBegin = sliceSize.getRasterBegin(intervalBegin);
                intervals = new TsIntervals();
            } else if (currentSliceBegin.isBefore(sliceSize.getRasterBegin(intervalBegin))) {
                slices.add(intervals);
                intervals = new TsIntervals();
                currentSliceBegin = sliceSize.getRasterBegin(intervalBegin);
            }
            Instant currentSliceEnd = sliceSize.getRasterEnd(intervalBegin);
            while (currentSliceEnd.isBefore(intervalEnd)) {
                intervals.addInterval(intervalBegin, currentSliceEnd);
                slices.add(intervals);
                intervals = new TsIntervals();
                currentSliceBegin = currentSliceEnd.plusNanos(1L);
                currentSliceEnd = sliceSize.getRasterEnd(currentSliceBegin);
                intervalBegin = currentSliceBegin;
            }
            intervals.addInterval(intervalBegin, intervalEnd);
        }
        if (intervals != null) {
            slices.add(intervals);
        }
        return (TsIntervals[])slices.toArray(TsIntervals[]::new);
    }

    public TsIntervals copy() {
        TsIntervals copy = new TsIntervals();
        this.getIntervals().forEach(i -> copy.addInterval(i.getFromTs(), i.getToTs()));
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TsIntervals)) {
            return false;
        }
        TsIntervals intervals = (TsIntervals)obj;
        if (this.getIntervals().size() != intervals.getIntervals().size()) {
            return false;
        }
        Iterator<TsInterval> objIterator = intervals.getIntervals().iterator();
        for (TsInterval interval : this.getIntervals()) {
            TsInterval objInterval;
            if (interval.equals(objInterval = objIterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = TsIntervals.class.hashCode();
        int multiplicator = 3;
        for (TsInterval interval : this.getIntervals()) {
            hashCode += multiplicator * interval.hashCode();
            multiplicator *= 3;
        }
        return hashCode;
    }

    public String toString() {
        String str = "";
        for (TsInterval interval : this.intervals) {
            str = String.valueOf(str) + interval.toString() + " ";
        }
        return str;
    }

    public static void main(String[] args) {
        VirtualZone.INSTANCE.addZoneOffset(Instant.ofEpochMilli(0L), new ZoneIdWithOffset(ZoneId.systemDefault(), ZoneOffset.ofHours(0)));
        TsIntervals intervals = new TsIntervals();
        intervals.addInterval(LocalDateTime.of(2021, 10, 1, 0, 0).atZone(ZoneId.systemDefault()).toInstant(), LocalDateTime.of(2021, 10, 1, 2, 0).atZone(ZoneId.systemDefault()).toInstant());
        intervals.addInterval(LocalDateTime.of(2021, 10, 2, 0, 0).atZone(ZoneId.systemDefault()).toInstant(), LocalDateTime.of(2021, 10, 3, 2, 0).atZone(ZoneId.systemDefault()).toInstant());
        intervals.addInterval(LocalDateTime.of(2021, 10, 4, 0, 0).atZone(ZoneId.systemDefault()).toInstant(), LocalDateTime.of(2021, 10, 5, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        intervals.addInterval(LocalDateTime.of(2021, 10, 5, 0, 0).atZone(ZoneId.systemDefault()).toInstant(), LocalDateTime.of(2021, 10, 6, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        intervals.addInterval(LocalDateTime.of(2021, 10, 6, 0, 0).atZone(ZoneId.systemDefault()).toInstant(), LocalDateTime.of(2021, 10, 7, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        intervals.addInterval(LocalDateTime.of(2021, 10, 7, 0, 0).atZone(ZoneId.systemDefault()).toInstant(), LocalDateTime.of(2021, 10, 8, 4, 0).atZone(ZoneId.systemDefault()).toInstant());
        System.out.println(intervals.toString());
        TsIntervals[] tsIntervalsArray = intervals.split(ComplexRaster.of(Raster.Minute_10));
        int n = tsIntervalsArray.length;
        int n2 = 0;
        while (n2 < n) {
            TsIntervals slice = tsIntervalsArray[n2];
            System.out.println(slice.toString());
            ++n2;
        }
    }
}

