/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.MeasuringUnitFormats;

public class DynamicMeasuringUnit
extends MeasuringUnit {
    private final double factor;
    private final double divisor;
    private final double addend;

    public DynamicMeasuringUnit(MeasuringUnitDefinition mud) {
        super(mud.getPhysicalUnitKey(), mud.getKey(), mud.getCommonCode());
        this.factor = mud.getFactor();
        this.divisor = mud.getDivisor();
        this.addend = mud.getAddend();
        if (mud.getSimpleDisplayUnit() != null) {
            this.putDisplayUnitText(DisplayUnitFormat.SIMPLE, mud.getSimpleDisplayUnit());
        }
        if (mud.getSimpleValueFormat() != null) {
            this.putValueFormat(MeasuringUnitFormats.SIMPLE, mud.getSimpleValueFormat());
        }
    }

    public void init() {
        this.getPhysicalUnit().addMeasuringUnit(this);
        UNITS.put(this.getId(), this);
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    @Override
    public double getDivisor() {
        return this.divisor;
    }

    @Override
    public double getAddend() {
        return this.addend;
    }
}

