/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.units.MeasuringUnitFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MeasuringUnitFormats {
    static Map<String, MeasuringUnitFormat> FORMATS = new LinkedHashMap<String, MeasuringUnitFormat>();
    public static final MeasuringUnitFormat SIMPLE = new MeasuringUnitFormat("simple", "Simple", "###,###,###,###,##0.000");
    public static final MeasuringUnitFormat TABLE = new MeasuringUnitFormat("table", "Table");
    public static final MeasuringUnitFormat INPUT = new MeasuringUnitFormat("input", "Input");
    public static final MeasuringUnitFormat F0_000 = new MeasuringUnitFormat("f0.000", "123.456.789,123", "###,###,###,###,##0.000");
    public static final MeasuringUnitFormat F0_00 = new MeasuringUnitFormat("f0.00", "123.456.789,12", "###,###,###,###,##0.00");
    public static final MeasuringUnitFormat F0_0 = new MeasuringUnitFormat("f0.0", "123.456.789,1", "###,###,###,###,##0.0");
    public static final MeasuringUnitFormat F0 = new MeasuringUnitFormat("f0", "123.456.789", "###,###,###,###,##0");
    public static final MeasuringUnitFormat FS0_000 = new MeasuringUnitFormat("fs0.000", "123456789,123", "##############0.000");
    public static final MeasuringUnitFormat FS0_00 = new MeasuringUnitFormat("fs0.00", "123456789,12", "##############0.00");
    public static final MeasuringUnitFormat FS0_0 = new MeasuringUnitFormat("fs0.0", "123456789,1", "##############0.0");
    public static final MeasuringUnitFormat FS0 = new MeasuringUnitFormat("fs0", "123456789", "##############0");
    public static final MeasuringUnitFormat FE0_000 = new MeasuringUnitFormat("fe0.000", "1,234E1", "0.000E0");
    public static final MeasuringUnitFormat FE0_00 = new MeasuringUnitFormat("fe0.00", "1,23E1", "0.00E0");
    public static final MeasuringUnitFormat FE0_0 = new MeasuringUnitFormat("fe0.0", "1,2E1", "0.0E0");

    public static Collection<MeasuringUnitFormat> getFormats() {
        return Collections.unmodifiableCollection(FORMATS.values());
    }

    public static MeasuringUnitFormat getOptimalFormat(double value) {
        if (Math.abs(value) >= 10000.0 || value == 0.0) {
            return F0;
        }
        if (Math.abs(value) >= 1000.0) {
            return F0_0;
        }
        if (Math.abs(value) >= 100.0) {
            return F0_00;
        }
        if (Math.abs(value) >= 0.005) {
            return F0_000;
        }
        return FE0_000;
    }
}

