/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.units;

import de.elpro.ewms.core.units.IPhysicalUnitsProvider;
import de.elpro.ewms.core.units.PhysicalUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.fx.core.ServiceUtils;

public class PhysicalUnitRegistry {
    private static final Map<String, PhysicalUnit> PREDEFINED_UNITS = new TreeMap<String, PhysicalUnit>();
    private static final Map<String, PhysicalUnit> UNITS = new TreeMap<String, PhysicalUnit>();

    static {
        try {
            for (IPhysicalUnitsProvider puProvider : ServiceUtils.getServiceList(IPhysicalUnitsProvider.class)) {
                for (PhysicalUnit unit : puProvider.getPhysicalUnits()) {
                    PREDEFINED_UNITS.put(unit.getKey(), unit);
                    UNITS.put(unit.getKey(), unit);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static Collection<PhysicalUnit> getPredefinedPhysicalUnits() {
        return Collections.unmodifiableCollection(PREDEFINED_UNITS.values());
    }

    public static PhysicalUnit getPredefinedPhysicalUnit(String key) {
        return PREDEFINED_UNITS.get(key);
    }

    public static PhysicalUnit getPhysicalUnit(String key) {
        return UNITS.get(key);
    }

    public static boolean containsPhysicalUnit(String key) {
        return UNITS.containsKey(key);
    }

    static void addPhysicalUnit(PhysicalUnit physicalUnit) {
        UNITS.put(physicalUnit.getKey(), physicalUnit);
    }

    public static Collection<PhysicalUnit> getPhysicalUnits() {
        return Collections.unmodifiableCollection(UNITS.values());
    }

    public static void cleadDynamicDefinitions() {
        LinkedList<PhysicalUnit> removeUnits = new LinkedList<PhysicalUnit>();
        for (PhysicalUnit pu2 : UNITS.values()) {
            if (!PREDEFINED_UNITS.containsKey(pu2.getKey())) {
                removeUnits.add(pu2);
            }
            pu2.clearDynamicMeasuringUnits();
        }
        removeUnits.stream().forEach(pu -> {
            PhysicalUnit physicalUnit = UNITS.remove(pu.getKey());
        });
    }
}

