/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable;

import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.text.DecimalFormat;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="ewms_variables_valuesbounds")
@Access(value=AccessType.PROPERTY)
public class ValuesBounds
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "valuesbounds";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<MeasuringUnit> measuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Double> highLimit = new SimpleObjectProperty();
    private final ObjectProperty<Double> lowLimit = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();

    public ValuesBounds() {
    }

    public ValuesBounds(int id) {
        this();
        this.setId(id);
    }

    public ValuesBounds(Double lowLimit, Double highLimit, MeasuringUnit measuringUnit) {
        this();
        this.setLowLimit(lowLimit);
        this.setHighLimit(highLimit);
        this.setMeasuringUnit(measuringUnit);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_variables_valuesbounds_sequence")
    @SequenceGenerator(name="ewms_variables_valuesbounds_sequence", sequenceName="ewms_variables_valuesbounds_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(Integer id) {
        this.id.set((Object)id);
    }

    @Column(name="name")
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="measuringunitid", nullable=false)
    public MeasuringUnit getMeasuringUnit() {
        return (MeasuringUnit)this.measuringUnit.get();
    }

    public void setMeasuringUnit(MeasuringUnit measuringUnit) {
        this.measuringUnit.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> measuringUnitProperty() {
        return this.measuringUnit;
    }

    @Column
    public Double getHighLimit() {
        return (Double)this.highLimit.get();
    }

    public void setHighLimit(Double highLimit) {
        this.highLimit.set((Object)highLimit);
    }

    public final ObjectProperty<Double> highLimitProperty() {
        return this.highLimit;
    }

    @Column
    public Double getLowLimit() {
        return (Double)this.lowLimit.get();
    }

    public void setLowLimit(Double lowLimit) {
        this.lowLimit.set((Object)lowLimit);
    }

    public final ObjectProperty<Double> lowLimitProperty() {
        return this.lowLimit;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValuesBounds)) {
            return false;
        }
        return this.hashCode() == ((ValuesBounds)obj).hashCode();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return ValuesBounds.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }

    public String toString() {
        String text = this.getName() == null ? "" : String.valueOf(this.getName()) + " ";
        DecimalFormat format = this.getMeasuringUnit().getValueFormat(MeasuringUnitFormats.SIMPLE);
        String lowLimitText = this.getLowLimit() != null ? format.format(this.getLowLimit()) : "-Inf.";
        String highLimitText = this.getHighLimit() != null ? format.format(this.getHighLimit()) : "+Inf.";
        return String.valueOf(text) + String.format("[%s : %s] %s", lowLimitText, highLimitText, this.getMeasuringUnit().getDisplayUnitText(DisplayUnitFormat.SIMPLE));
    }
}

