/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable;

import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Medium;
import de.elpro.ewms.core.variable.Source;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableProperty;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencies;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_variables_variable", uniqueConstraints={@UniqueConstraint(name="eos_variables_variable_unique_constraint", columnNames={"structure_class", "location", "medium", "physical_unit_id", "specialization", "specialization_2", "source"})})
@Access(value=AccessType.PROPERTY)
public class Variable
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "variable";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/variable.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final ObjectProperty<Location> location = new SimpleObjectProperty();
    private final ObjectProperty<Medium> medium = new SimpleObjectProperty();
    private final ObjectProperty<PhysicalUnit> physicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<Specialization> specialization = new SimpleObjectProperty();
    private final ObjectProperty<Specialization> specialization2 = new SimpleObjectProperty();
    private final ObjectProperty<Source> source = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> measuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<ValuesBounds> valuesBounds = new SimpleObjectProperty();
    private final ObjectProperty<Aggregation> aggregation = new SimpleObjectProperty();
    private final ObjectProperty<Aggregation> plcRawValueAggregation = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> plcSourceMU = new SimpleObjectProperty();
    private final ObjectProperty<DataGroup> plcDefaultDataGroup = new SimpleObjectProperty();
    private final StringProperty plcDatasourceKeyPattern = new SimpleStringProperty();
    private final StringProperty defaultCalculationFormula = new SimpleStringProperty();
    private final StringProperty defaultCustomAlgorithmId = new SimpleStringProperty();
    private final StringProperty defaultCustomAlgorithmDependenciesDef = new SimpleStringProperty();
    private final transient ObjectProperty<CustomAlgorithmDependencies> defaultCustomAlgorithmDependencies = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();
    private Set<VariableProperty> defaultProperties = new HashSet<VariableProperty>();
    private Set<String> roleIds = new LinkedHashSet<String>();
    private Set<VariableInstance> instances = new LinkedHashSet<VariableInstance>();
    private SimpleStringProperty structureClassToken = new SimpleStringProperty();
    private boolean enabled = true;

    public Variable() {
        Bindings.bindBidirectional((Property)this.defaultCustomAlgorithmDependenciesDef, this.defaultCustomAlgorithmDependencies, CustomAlgorithmDependencies.CONVERTER);
    }

    public Variable(int id) {
        this();
        this.setId(id);
    }

    public Variable(StructureClass structureClass, Location location, Medium medium, MeasuringUnit measuringUnit, Specialization specialization, Source source) {
        this();
        this.structureClass.set((Object)structureClass);
        this.location.set((Object)location);
        this.medium.set((Object)medium);
        this.physicalUnit.set((Object)measuringUnit.getPhysicalUnit());
        this.measuringUnit.set((Object)measuringUnit);
        this.specialization.set((Object)specialization);
        this.source.set((Object)source);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_variables_variable_sequence")
    @SequenceGenerator(name="ewms_variables_variable_sequence", sequenceName="ewms_variables_variable_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @ManyToOne
    @JoinColumn(name="location")
    public Location getLocation() {
        return (Location)this.location.get();
    }

    public void setLocation(Location location) {
        this.location.set((Object)location);
    }

    public final ObjectProperty<Location> locationProperty() {
        return this.location;
    }

    @ManyToOne
    @JoinColumn(name="medium", nullable=false)
    public Medium getMedium() {
        return (Medium)this.medium.get();
    }

    public void setMedium(Medium medium) {
        this.medium.set((Object)medium);
    }

    public final ObjectProperty<Medium> mediumProperty() {
        return this.medium;
    }

    @Column(name="physical_unit_id", nullable=false)
    public PhysicalUnit getPhysicalUnit() {
        return (PhysicalUnit)this.physicalUnit.get();
    }

    public void setPhysicalUnit(PhysicalUnit physicalUnit) {
        this.physicalUnit.set((Object)physicalUnit);
    }

    public final ObjectProperty<PhysicalUnit> physicalUnitProperty() {
        return this.physicalUnit;
    }

    @ManyToOne
    @JoinColumn(name="specialization")
    public Specialization getSpecialization() {
        return (Specialization)this.specialization.get();
    }

    public void setSpecialization(Specialization specialization) {
        this.specialization.set((Object)specialization);
    }

    public final ObjectProperty<Specialization> specializationProperty() {
        return this.specialization;
    }

    @ManyToOne
    @JoinColumn(name="specialization_2")
    public Specialization getSpecialization2() {
        return (Specialization)this.specialization2.get();
    }

    public void setSpecialization2(Specialization specialization2) {
        this.specialization2.set((Object)specialization2);
    }

    public final ObjectProperty<Specialization> specialization2Property() {
        return this.specialization2;
    }

    @ManyToOne
    @JoinColumn(name="source", nullable=false)
    public Source getSource() {
        return (Source)this.source.get();
    }

    public void setSource(Source source) {
        this.source.set((Object)source);
    }

    public final ObjectProperty<Source> sourceProperty() {
        return this.source;
    }

    @Column(name="measuring_unit_id", nullable=false)
    public MeasuringUnit getMeasuringUnit() {
        return (MeasuringUnit)this.measuringUnit.get();
    }

    public void setMeasuringUnit(MeasuringUnit measuringUnit) {
        this.measuringUnit.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> measuringUnitProperty() {
        return this.measuringUnit;
    }

    @ManyToOne
    @JoinColumn(name="values_bounds")
    public ValuesBounds getValuesBounds() {
        return (ValuesBounds)this.valuesBounds.get();
    }

    public void setValuesBounds(ValuesBounds valuesBounds) {
        this.valuesBounds.set((Object)valuesBounds);
    }

    public final ObjectProperty<ValuesBounds> valuesBoundsProperty() {
        return this.valuesBounds;
    }

    @Column(name="aggregation")
    public Aggregation getAggregation() {
        return (Aggregation)((Object)this.aggregation.get());
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation.set((Object)aggregation);
    }

    public final ObjectProperty<Aggregation> aggregationProperty() {
        return this.aggregation;
    }

    @Transient
    public Aggregation getResultAggregation() {
        if (this.getAggregation() != null) {
            return this.getAggregation();
        }
        return this.getPhysicalUnit() != null ? this.getPhysicalUnit().getAggregation() : null;
    }

    @Column(name="plc_raw_value_aggregation")
    public Aggregation getPlcRawValueAggregation() {
        return (Aggregation)((Object)this.plcRawValueAggregation.get());
    }

    public void setPlcRawValueAggregation(Aggregation plcRawValueAggregation) {
        this.plcRawValueAggregation.set((Object)plcRawValueAggregation);
    }

    public final ObjectProperty<Aggregation> plcRawValueAggregationProperty() {
        return this.plcRawValueAggregation;
    }

    @Transient
    public Aggregation getResultPlcRawValueAggregation() {
        if (this.getPlcRawValueAggregation() != null) {
            return this.getPlcRawValueAggregation();
        }
        return this.getResultAggregation();
    }

    @Column(name="plc_source_mu_id")
    public MeasuringUnit getPlcSourceMU() {
        return (MeasuringUnit)this.plcSourceMU.get();
    }

    public void setPlcSourceMU(MeasuringUnit plcSourceMU) {
        this.plcSourceMU.set((Object)plcSourceMU);
    }

    @Transient
    public MeasuringUnit getResultPlcSourceMU() {
        if (this.getPlcSourceMU() != null) {
            return this.getPlcSourceMU();
        }
        return this.getMeasuringUnit();
    }

    public final ObjectProperty<MeasuringUnit> plcSourceMUProperty() {
        return this.plcSourceMU;
    }

    @ManyToOne
    @JoinColumn(name="plc_default_data_group")
    public DataGroup getPlcDefaultDataGroup() {
        return (DataGroup)this.plcDefaultDataGroup.get();
    }

    public void setPlcDefaultDataGroup(DataGroup dataGroup) {
        this.plcDefaultDataGroup.set((Object)dataGroup);
    }

    public final ObjectProperty<DataGroup> plcDefaultDataGroupProperty() {
        return this.plcDefaultDataGroup;
    }

    @Column(name="plc_datasource_key_pattern", columnDefinition="TEXT")
    public String getPlcDatasourceKeyPattern() {
        return (String)this.plcDatasourceKeyPattern.get();
    }

    public void setPlcDatasourceKeyPattern(String plcDatasoruceKeyPattern) {
        this.plcDatasourceKeyPattern.set((Object)plcDatasoruceKeyPattern);
    }

    public StringProperty plcDatasourceKeyPatternProperty() {
        return this.plcDatasourceKeyPattern;
    }

    @Column(name="default_calculation_formula", columnDefinition="TEXT")
    public String getDefaultCalculationFormula() {
        return (String)this.defaultCalculationFormula.get();
    }

    public void setDefaultCalculationFormula(String defaultCalculationFormula) {
        this.defaultCalculationFormula.set((Object)defaultCalculationFormula);
    }

    public final StringProperty defaultCalculationFormulaProperty() {
        return this.defaultCalculationFormula;
    }

    @Column(name="default_custom_algorithm_id")
    public String getDefaultCustomAlgorithmId() {
        return (String)this.defaultCustomAlgorithmId.get();
    }

    public void setDefaultCustomAlgorithmId(String defaultCustomAlgorithmId) {
        this.defaultCustomAlgorithmId.set((Object)defaultCustomAlgorithmId);
    }

    public final StringProperty defaultCustomAlgorithmId() {
        return this.defaultCustomAlgorithmId;
    }

    public final StringProperty defaultCustomAlgorithmDependenciesDef() {
        return this.defaultCustomAlgorithmDependenciesDef;
    }

    @Column(name="default_custom_algorithm_dependencies", columnDefinition="TEXT")
    public String getDefaultCustomAlgorithmDependenciesDef() {
        return (String)this.defaultCustomAlgorithmDependenciesDef.get();
    }

    public void setDefaultCustomAlgorithmDependenciesDef(String defaultCustomAlgorithmDependencies) {
        this.defaultCustomAlgorithmDependenciesDef.set((Object)defaultCustomAlgorithmDependencies);
    }

    public final ObjectProperty<CustomAlgorithmDependencies> defaultCustomAlgorithmDependencies() {
        return this.defaultCustomAlgorithmDependencies;
    }

    @Transient
    public CustomAlgorithmDependencies getDefaultCustomAlgorithmDependencies() {
        return (CustomAlgorithmDependencies)this.defaultCustomAlgorithmDependencies.get();
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @OneToMany(mappedBy="variable", orphanRemoval=true)
    public Set<VariableProperty> getDefaultProperties() {
        return this.defaultProperties;
    }

    protected void setDefaultProperties(Set<VariableProperty> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    @ElementCollection
    @CollectionTable(name="ewms_variables_variable_roles", joinColumns={@JoinColumn(name="variable_id")})
    @Column(name="role_id")
    public Set<String> getRoleIds() {
        return this.roleIds;
    }

    protected void setRoleIds(Set<String> roleIds) {
        this.roleIds = roleIds;
    }

    @Transient
    public String getDefaultProperty(String key) {
        for (VariableProperty defaultProperty : this.defaultProperties) {
            if (!defaultProperty.getKey().equals(key)) continue;
            return defaultProperty.getValue();
        }
        return null;
    }

    public void setDefaultProperty(String key, String value) {
        for (VariableProperty defaultProperty : this.defaultProperties) {
            if (!defaultProperty.getKey().equals(key)) continue;
            defaultProperty.setValue(value);
            return;
        }
        VariableProperty newProperty = new VariableProperty(this, key);
        newProperty.setValue(value);
        this.defaultProperties.add(newProperty);
    }

    @Transient
    public String getStructureResultClassToken() {
        if (this.structureClassToken.get() == null) {
            if (this.getStructureClass() != null) {
                this.structureClassToken.set(this.getStructureClass().getResultToken());
            } else {
                this.structureClassToken.set("unknown");
            }
        }
        return this.structureClassToken.get();
    }

    public void setStructureClassResultToken(String token) {
        this.structureClassToken.set(token);
    }

    @OneToMany(mappedBy="variable")
    public Set<VariableInstance> getInstances() {
        return this.instances;
    }

    protected void setInstances(Set<VariableInstance> instances) {
        this.instances = instances;
    }

    @Transient
    public String getTextIdentifier() {
        return String.format("EOS/Variables/%s", this.toString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Variable)) {
            return false;
        }
        return this.hashCode() == ((Variable)obj).hashCode();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return Variable.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }

    public String toString() {
        try {
            return String.format("%s%s.%s.%s%s%s.%s", this.getStructureResultClassToken(), this.getLocation() != null ? "_" + this.getLocation().getValue() : "", this.getMedium().getValue(), this.getPhysicalUnit().getName(), this.getSpecialization() != null ? "_" + this.getSpecialization().getValue() : "", this.getSpecialization2() != null ? "_" + this.getSpecialization2().getValue() : "", this.getSource().getValue());
        }
        catch (Exception exception) {
            return "<undefined>";
        }
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    @Transient
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

