/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable;

import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.Interpolation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.PLCVariableInstanceType;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.calculated.dependencies.CustomAlgorithmDependencies;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceExplicitDependency;
import de.elpro.resources.Resources;
import de.elpro.ui.bindings.ObjectExpressions;
import de.elpro.ui.model.CustomUILabelElement;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_variables_variableinstance", uniqueConstraints={@UniqueConstraint(columnNames={"variable", "structure_object"})})
@Access(value=AccessType.PROPERTY)
public class VariableInstance
extends CustomUILabelElement
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "variable/instance";
    private static final URL NONE_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/variable_instance_none.png");
    private static final URL PLC_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/variable_instance_plc.png");
    private static final URL CALCULATED_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/variable_instance_calc.png");
    private static final URL CUSTOM_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/variable_instance_custom.png");
    private static final URL RASTERIZED_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/variable_instance_rast_sup.png");
    private static final URL UNRASTERIZED_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/variable_instance_unrast_sup.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<VariableInstanceType> type = new SimpleObjectProperty((Object)VariableInstanceType.None);
    private final ObjectProperty<SupplementValueStrategy> supplementValueStrategy = new SimpleObjectProperty();
    private final ObjectProperty<Variable> variable = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final ObjectProperty<VariableInstance> upperLimit = new SimpleObjectProperty();
    private final ObjectProperty<VariableInstance> lowerLimit = new SimpleObjectProperty();
    private final ObjectProperty<ValuesBounds> valuesBounds = new SimpleObjectProperty();
    private final ObjectProperty<Interpolation> interpolation = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final ObjectProperty<MeasuringUnit> plcSourceMU = new SimpleObjectProperty();
    private final ObjectProperty<PLCVariableInstanceType> plcInstanceType = new SimpleObjectProperty((Object)PLCVariableInstanceType.Direct);
    private final ObjectProperty<Aggregation> plcRawValueAggregation = new SimpleObjectProperty();
    private final StringProperty plcDatasourceKey = new SimpleStringProperty();
    private final BooleanProperty positiveLogic = new SimpleBooleanProperty(true);
    private final ObjectProperty<DataGroup> plcDataGroup = new SimpleObjectProperty();
    private final ObjectProperty<VariableInstance> writeValuesSource = new SimpleObjectProperty();
    private final StringProperty calculationFormula = new SimpleStringProperty();
    private final StringProperty algorithmId = new SimpleStringProperty();
    private final StringProperty customAlgorithmDependenciesDef = new SimpleStringProperty();
    private final ObjectProperty<CustomAlgorithmDependencies> customAlgorithmDependencies = new SimpleObjectProperty();
    private final StringProperty parameter = new SimpleStringProperty();
    private List<VariableInstanceExplicitDependency> dependencies = new ArrayList<VariableInstanceExplicitDependency>();
    private List<VariableInstanceExplicitDependency> cachedDependencies = new ArrayList<VariableInstanceExplicitDependency>();
    private SimpleObjectProperty<VariableInstance> link = new SimpleObjectProperty();

    public VariableInstance() {
        Bindings.bindBidirectional((Property)this.customAlgorithmDependenciesDef, this.customAlgorithmDependencies, CustomAlgorithmDependencies.CONVERTER);
    }

    public VariableInstance(int id) {
        this();
        this.setId(id);
    }

    public VariableInstance(VariableInstanceType type, SupplementValueStrategy supplementStrategy, Variable variable, StructureObject structureObject) {
        this();
        this.setType(type);
        this.setSupplementValueStrategy(supplementStrategy);
        this.setVariable(variable);
        this.setStructureObject(structureObject);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_variables_variableinstance_sequence")
    @SequenceGenerator(name="ewms_variables_variableinstance_sequence", sequenceName="ewms_variables_variableinstance_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public ObservableValue<Integer> idProperty() {
        return ObjectExpressions.createExpression(this.id);
    }

    @Column(name="type")
    public VariableInstanceType getType() {
        return (VariableInstanceType)((Object)this.type.get());
    }

    public void setType(VariableInstanceType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<VariableInstanceType> typeProperty() {
        return this.type;
    }

    @Column(name="supplement_value_strategy")
    public SupplementValueStrategy getSupplementValueStrategy() {
        return (SupplementValueStrategy)((Object)this.supplementValueStrategy.get());
    }

    public void setSupplementValueStrategy(SupplementValueStrategy strategy) {
        this.supplementValueStrategy.set((Object)strategy);
    }

    public final ObjectProperty<SupplementValueStrategy> supplementValueStrategy() {
        return this.supplementValueStrategy;
    }

    @ManyToOne
    @JoinColumn(name="variable", nullable=false)
    public Variable getVariable() {
        return (Variable)this.variable.get();
    }

    public void setVariable(Variable variable) {
        this.variable.set((Object)variable);
    }

    public final ObjectProperty<Variable> variableProperty() {
        return this.variable;
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=false)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    public void setStructureObject(StructureObject structureObject) {
        this.structureObject.set((Object)structureObject);
    }

    public final ObjectProperty<StructureObject> structureObjectProperty() {
        return this.structureObject;
    }

    @ManyToOne
    @JoinColumn(name="upper_limit")
    public VariableInstance getUpperLimit() {
        return (VariableInstance)((Object)this.upperLimit.get());
    }

    public void setUpperLimit(VariableInstance upperLimit) {
        this.upperLimit.set((Object)upperLimit);
    }

    @ManyToOne
    @JoinColumn(name="lower_limit")
    public VariableInstance getLowerLimit() {
        return (VariableInstance)((Object)this.lowerLimit.get());
    }

    public void setLowerLimit(VariableInstance lowerLimit) {
        this.lowerLimit.set((Object)lowerLimit);
    }

    @ManyToOne
    @JoinColumn(name="values_bounds")
    public ValuesBounds getValuesBounds() {
        return (ValuesBounds)this.valuesBounds.get();
    }

    public void setValuesBounds(ValuesBounds valuesBounds) {
        this.valuesBounds.set((Object)valuesBounds);
    }

    public final ObjectProperty<ValuesBounds> valuesBoundsProperty() {
        return this.valuesBounds;
    }

    @Transient
    public ValuesBounds getResultValuesBounds() {
        if (this.getValuesBounds() != null) {
            return this.getValuesBounds();
        }
        return this.getVariable().getValuesBounds();
    }

    @Column(name="interpolation")
    public Interpolation getInterpolation() {
        return (Interpolation)((Object)this.interpolation.get());
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation.set((Object)interpolation);
    }

    public final ObjectProperty<Interpolation> interpolationProperty() {
        return this.interpolation;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @Transient
    public String getResultDescription() {
        if (this.getDescription() != null && !this.getDescription().trim().isEmpty()) {
            return this.getDescription();
        }
        if (this.getVariable() != null) {
            return this.getVariable().getDescription();
        }
        return null;
    }

    @Column(name="plc_source_mu_id")
    public MeasuringUnit getPlcSourceMU() {
        return (MeasuringUnit)this.plcSourceMU.get();
    }

    public void setPlcSourceMU(MeasuringUnit plcSourceMU) {
        this.plcSourceMU.set((Object)plcSourceMU);
    }

    public final ObjectProperty<MeasuringUnit> plcSourceMUProperty() {
        return this.plcSourceMU;
    }

    @Transient
    public MeasuringUnit getResultArchiveMeasuringUnit() {
        if (this.getPlcSourceMU() != null) {
            return this.getPlcSourceMU();
        }
        if (this.getVariable() == null) {
            return null;
        }
        return this.getVariable().getResultPlcSourceMU();
    }

    @Column(name="plc_instance_type", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public PLCVariableInstanceType getPLCInstanceType() {
        return (PLCVariableInstanceType)((Object)this.plcInstanceType.get());
    }

    public void setPLCInstanceType(PLCVariableInstanceType type) {
        this.plcInstanceType.set((Object)type);
    }

    public final ObjectProperty<PLCVariableInstanceType> plcInstanceTypeProperty() {
        return this.plcInstanceType;
    }

    @Column(name="plc_raw_value_aggregation")
    public Aggregation getPlcRawValueAggregation() {
        return (Aggregation)((Object)this.plcRawValueAggregation.get());
    }

    public void setPlcRawValueAggregation(Aggregation plcRawValueAggregation) {
        this.plcRawValueAggregation.set((Object)plcRawValueAggregation);
    }

    public final ObjectProperty<Aggregation> plcRawValueAggregationProperty() {
        return this.plcRawValueAggregation;
    }

    @Transient
    public Aggregation getResultPlcRawValueAggregation() {
        if (this.getPlcRawValueAggregation() != null) {
            return this.getPlcRawValueAggregation();
        }
        return this.getVariable().getResultPlcRawValueAggregation();
    }

    @Column(name="datasource_key")
    public String getPlcDatasourceKey() {
        return (String)this.plcDatasourceKey.get();
    }

    public void setPlcDatasourceKey(String datasourceKey) {
        this.plcDatasourceKey.set((Object)datasourceKey);
    }

    public final StringProperty plcDataSourceKeyProperty() {
        return this.plcDatasourceKey;
    }

    @Transient
    public String getResultPlcDatasourceKey() {
        String datasourceKey = this.getPlcDatasourceKey();
        if (datasourceKey != null && !datasourceKey.trim().isEmpty()) {
            return datasourceKey;
        }
        String datasoruceKeyPattern = this.getVariable().getPlcDatasourceKeyPattern();
        if (datasoruceKeyPattern == null || datasoruceKeyPattern.trim().isEmpty()) {
            return null;
        }
        datasoruceKeyPattern = datasoruceKeyPattern.trim();
        Map<String, String> aliasKeyMap = this.getStructureObject().getPlcAliasMap();
        if (aliasKeyMap == null) {
            return datasoruceKeyPattern;
        }
        for (Map.Entry<String, String> alias : aliasKeyMap.entrySet()) {
            String aliasKeyPlaceholder = String.format("{%s}", alias.getKey());
            datasoruceKeyPattern = datasoruceKeyPattern.replace(aliasKeyPlaceholder, alias.getValue());
        }
        return datasoruceKeyPattern;
    }

    @Column(name="positive_logic", columnDefinition="boolean default true", nullable=false)
    public boolean getPositiveLogic() {
        return this.positiveLogic.get();
    }

    public void setPositiveLogic(boolean positiveLogic) {
        this.positiveLogic.set(positiveLogic);
    }

    @ManyToOne
    @JoinColumn(name="data_group")
    public DataGroup getPlcDataGroup() {
        return (DataGroup)this.plcDataGroup.get();
    }

    public void setPlcDataGroup(DataGroup dataGroup) {
        this.plcDataGroup.set((Object)dataGroup);
    }

    public final ObjectProperty<DataGroup> plcDataGroupProperty() {
        return this.plcDataGroup;
    }

    @Transient
    public DataGroup getResultPlcDataGroup() {
        if (this.getPlcDataGroup() != null) {
            return this.getPlcDataGroup();
        }
        return this.getVariable().getPlcDefaultDataGroup();
    }

    @ManyToOne
    @JoinColumn(name="write_values_source")
    public VariableInstance getWriteValuesSource() {
        return (VariableInstance)((Object)this.writeValuesSource.get());
    }

    public void setWriteValuesSource(VariableInstance variableInstance) {
        this.writeValuesSource.set((Object)variableInstance);
    }

    public final ObjectProperty<VariableInstance> writeValuesSourceProperty() {
        return this.writeValuesSource;
    }

    @Column(name="calculation_formula", columnDefinition="TEXT")
    public String getCalculationFormula() {
        return (String)this.calculationFormula.get();
    }

    public void setCalculationFormula(String calculationFormula) {
        this.calculationFormula.set((Object)calculationFormula);
    }

    public final StringProperty calculationFormulaProperty() {
        return this.calculationFormula;
    }

    @Transient
    public String getResultCalculationFormula() {
        if (this.getCalculationFormula() != null && !this.getCalculationFormula().isEmpty()) {
            return this.getCalculationFormula();
        }
        return this.getVariable().getDefaultCalculationFormula();
    }

    @Column(name="algorithm_id")
    public String getCustomAlgorithmId() {
        return (String)this.algorithmId.get();
    }

    public void setCustomAlgorithmId(String algorithmId) {
        this.algorithmId.set((Object)algorithmId);
    }

    @Transient
    public String getResultCustomAlgorithmId() {
        if (this.getCustomAlgorithmId() == null || this.getCustomAlgorithmId().isEmpty()) {
            return this.getVariable().getDefaultCustomAlgorithmId();
        }
        return this.getCustomAlgorithmId();
    }

    public final StringProperty customAlgorithmId() {
        return this.algorithmId;
    }

    public final StringProperty customAlgorithmDependenciesDef() {
        return this.customAlgorithmDependenciesDef;
    }

    @Column(name="custom_algorithm_dependencies", columnDefinition="TEXT")
    public String getCustomAlgorithmDependenciesDef() {
        return (String)this.customAlgorithmDependenciesDef.get();
    }

    public void setCustomAlgorithmDependenciesDef(String customAlgorithmDependencies) {
        this.customAlgorithmDependenciesDef.set((Object)customAlgorithmDependencies);
    }

    public final ObjectProperty<CustomAlgorithmDependencies> customAlgorithmDependencies() {
        return this.customAlgorithmDependencies;
    }

    @Transient
    public CustomAlgorithmDependencies getCustomAlgorithmDependencies() {
        return (CustomAlgorithmDependencies)this.customAlgorithmDependencies.get();
    }

    @Column(name="parameter")
    public String getParameter() {
        return (String)this.parameter.get();
    }

    public void setParameter(String parameter) {
        this.parameter.set((Object)parameter);
    }

    @OneToMany(mappedBy="variableInstance", orphanRemoval=true)
    @OrderBy(value="key")
    public List<VariableInstanceExplicitDependency> getDependencies() {
        return this.dependencies;
    }

    protected void setDependencies(List<VariableInstanceExplicitDependency> dependencies) {
        this.dependencies = dependencies;
    }

    @Transient
    public final List<VariableInstanceExplicitDependency> getCachedDependencies() {
        return this.cachedDependencies;
    }

    public void cacheDependencies() {
        this.cachedDependencies.addAll(this.getDependencies());
    }

    public void addDependency(VariableInstance dependentOn, String key) {
        this.getDependencies().add(new VariableInstanceExplicitDependency(this, dependentOn, key));
    }

    public void removeDependency(VariableInstance dependentOn, String key) {
        for (VariableInstanceExplicitDependency dep : this.getDependencies()) {
            if (!dep.getDependentOn().equals((Object)dependentOn) || (key != null || dep.getKey() != null) && (key == null || !key.equals(dep.getKey()))) continue;
            this.getDependencies().remove(dep);
            return;
        }
    }

    @Transient
    public List<VariableInstance> getDependencies(String key) {
        LinkedList<VariableInstance> dependencies = new LinkedList<VariableInstance>();
        for (VariableInstanceExplicitDependency dep : this.getDependencies()) {
            if ((key != null || dep.getKey() != null) && !key.equals(dep.getKey())) continue;
            dependencies.add(dep.getDependentOn());
        }
        return dependencies;
    }

    @Transient
    public VariableInstance getDependency(String key) {
        LinkedList<VariableInstance> dependencies = new LinkedList<VariableInstance>();
        for (VariableInstanceExplicitDependency dep : this.getDependencies()) {
            if ((key != null || dep.getKey() != null) && !key.equals(dep.getKey())) continue;
            dependencies.add(dep.getDependentOn());
        }
        if (dependencies.size() != 1) {
            throw new IllegalArgumentException(String.format("Illegal number of instances %d for '%s' key", dependencies.size(), key));
        }
        return (VariableInstance)((Object)dependencies.getFirst());
    }

    @ManyToOne
    @JoinColumn(name="link")
    public VariableInstance getLink() {
        return (VariableInstance)((Object)this.link.get());
    }

    public void setLink(VariableInstance link) {
        this.link.set((Object)link);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VariableInstance)) {
            return false;
        }
        return this.hashCode() == ((VariableInstance)((Object)obj)).hashCode();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return VariableInstance.class.hashCode() + 17 * this.getId();
        }
        return super.hashCode();
    }

    @Transient
    public Node getGraphic() {
        Group group = new Group();
        if (this.getType() != null) {
            switch (this.getType()) {
                case None: {
                    group.getChildren().add((Object)new ImageView(NONE_ICON.toString()));
                    break;
                }
                case PLC: {
                    group.getChildren().add((Object)new ImageView(PLC_ICON.toString()));
                    break;
                }
                case Calculated: {
                    group.getChildren().add((Object)new ImageView(CALCULATED_ICON.toString()));
                    break;
                }
                case Custom: {
                    group.getChildren().add((Object)new ImageView(CUSTOM_ICON.toString()));
                    break;
                }
            }
        }
        if (this.getSupplementValueStrategy() != null) {
            switch (this.getSupplementValueStrategy()) {
                case Rasterized: {
                    group.getChildren().add((Object)new ImageView(RASTERIZED_ICON.toString()));
                    break;
                }
                case Unrasterized: {
                    group.getChildren().add((Object)new ImageView(UNRASTERIZED_ICON.toString()));
                    break;
                }
            }
        }
        return group;
    }

    public String toString() {
        if (this.buildTextLableCallback != null) {
            return this.buildTextLableCallback.buildTextLabel((CustomUILabelElement)this);
        }
        if (this.getStructureObject() != null) {
            return this.getStructureObject().toString();
        }
        return this.getId().toString();
    }

    @Transient
    public String getFullName() {
        return String.format("%s - %s", this.getVariable(), this.getStructureObject());
    }

    @Transient
    public String getTextIdentifier() {
        return String.format("%s/%s", this.getVariable().getTextIdentifier(), this.getStructureObject().getTextIdentifier());
    }
}

