/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VariableProperties {
    public static final VariablePropertyGroup GROUP_ARCH = new VariablePropertyGroup("plc", "PLC");
    public static final VariablePropertyGroup GROUP_CALC = new VariablePropertyGroup("calculation", "Calculation");
    public static final VariablePropertyGroup GROUP_CUSTOM = new VariablePropertyGroup("custom", "Custom");
    public static final VariablePropertyGroup GROUP_MISC = new VariablePropertyGroup("misc", "Misc");
    private static final Map<VariablePropertyGroup, List<VariablePropertyDescription>> GROUPS = new LinkedHashMap<VariablePropertyGroup, List<VariablePropertyDescription>>();

    public static void addPropertyDescription(VariablePropertyGroup group, String key, String name, String hint, boolean useAreaEditor) {
        List<VariablePropertyDescription> properties = GROUPS.get(group);
        if (properties == null) {
            properties = new LinkedList<VariablePropertyDescription>();
            GROUPS.put(group, properties);
        }
        properties.add(new VariablePropertyDescription(key, name, hint, useAreaEditor));
    }

    public static Collection<VariablePropertyGroup> getGroups() {
        return Collections.unmodifiableCollection(GROUPS.keySet());
    }

    public static Collection<VariablePropertyDescription> getDescriptions(VariablePropertyGroup group) {
        return Collections.unmodifiableCollection((Collection)GROUPS.get(group));
    }

    public static class VariablePropertyDescription {
        private final String key;
        private final String name;
        private final String hint;
        private final boolean useAreaEditor;

        private VariablePropertyDescription(String key, String name, String hint, boolean useAreaEditor) {
            this.key = key;
            this.name = name;
            this.hint = hint;
            this.useAreaEditor = useAreaEditor;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getHint() {
            return this.hint;
        }

        public boolean getUseAreaEditor() {
            return this.useAreaEditor;
        }
    }

    public static class VariablePropertyGroup {
        private final String id;
        private final String name;

        public VariablePropertyGroup(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

