/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.calculated;

import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.variable.calculated.Characteristic2DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic2DReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DReference;
import de.elpro.ewms.core.variable.calculated.FormulaNodeType;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import de.elpro.ewms.core.variable.calculated.PropertyInstanceReference;
import de.elpro.ewms.core.variable.calculated.PropertyReference;
import de.elpro.ewms.core.variable.calculated.VariableInstanceReference;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class FormulaNode {
    private TreeMap<String, String> operationParameters = new TreeMap();
    private final String name;
    private final ArrayList<FormulaNode> parameters;
    private FormulaNodeType type;
    private Object nodeObject;
    private String stringRepresentation = null;
    private Boolean conatainsCumulativeOperation = null;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$de$elpro$ewms$core$variable$calculated$FormulaNodeType;

    public FormulaNode(String name) {
        this(null, name, new ArrayList<FormulaNode>());
    }

    public FormulaNode(FormulaNodeType type, String name) {
        this(type, name, new ArrayList<FormulaNode>());
    }

    public FormulaNode(String name, ArrayList<FormulaNode> parameters) {
        this(null, name, parameters);
    }

    public FormulaNode(FormulaNodeType type, String name, ArrayList<FormulaNode> parameters) {
        this.type = type;
        this.name = name;
        this.parameters = parameters;
    }

    public synchronized FormulaNodeType getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.name == null) {
            this.type = FormulaNodeType.Empty;
            return this.type;
        }
        if (this.name.startsWith("$")) {
            if (this.name.contains(">~<")) {
                this.type = FormulaNodeType.Characteristic3DRef;
                return this.type;
            }
            if (this.name.contains("~")) {
                this.type = FormulaNodeType.Characteristic2DRef;
                return this.type;
            }
            if (this.name.split("\\.").length == 4) {
                this.type = FormulaNodeType.VariableRef;
                return this.type;
            }
            this.type = FormulaNodeType.PropertyRef;
            return this.type;
        }
        try {
            if ("NaN".equals(this.name) || "RASTER".equals(this.name)) {
                this.type = FormulaNodeType.Constant;
                return this.type;
            }
            Double.parseDouble(this.name);
            this.type = FormulaNodeType.Constant;
            return this.type;
        }
        catch (Exception exception) {
            try {
                FormulaOperation.valueOf(this.name);
                this.type = FormulaNodeType.Operation;
                return this.type;
            }
            catch (Exception exception2) {
                if (this.name != null && this.name.startsWith("\"") && this.name.endsWith("\"")) {
                    this.type = FormulaNodeType.Text;
                    return this.type;
                }
                this.type = this.name != null ? FormulaNodeType.Parameter : FormulaNodeType.Empty;
                return this.type;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Object getNodeObject() {
        if (this.nodeObject != null) {
            return this.nodeObject;
        }
        switch (FormulaNode.$SWITCH_TABLE$de$elpro$ewms$core$variable$calculated$FormulaNodeType()[this.getType().ordinal()]) {
            case 6: {
                try {
                    parts = this.name.substring(1).split("->");
                    if (parts.length != 2) ** break;
                    try {
                        policy = SearchPolicy.valueOf(parts[1]);
                        this.nodeObject = new Characteristic2DReference(parts[0], policy);
                        return this.nodeObject;
                    }
                    catch (Exception v0) {
                        this.nodeObject = new Characteristic2DInstanceReference(parts[0], parts[1]);
                        return this.nodeObject;
                    }
                }
                catch (Exception v1) {}
                break;
            }
            case 7: {
                try {
                    parts = this.name.substring(1).split("->");
                    if (parts.length != 2) ** break;
                    zwSelection = this.getOperationParameters().get("OutputAxis");
                    if (zwSelection == null || zwSelection.isBlank()) {
                        zwSelection = "z";
                    }
                    try {
                        policy = SearchPolicy.valueOf(parts[1]);
                        this.nodeObject = new Characteristic3DReference(parts[0], policy, zwSelection);
                        return this.nodeObject;
                    }
                    catch (Exception v2) {
                        this.nodeObject = new Characteristic3DInstanceReference(parts[0], parts[1], zwSelection);
                        return this.nodeObject;
                    }
                }
                catch (Exception v3) {}
                break;
            }
            case 8: {
                try {
                    parts = this.name.substring(1).split("->");
                    if (parts.length != 2) ** break;
                    getX = true;
                    xySelector = this.getOperationParameters().get("OutputAxis");
                    if (xySelector != null && xySelector.equals("y")) {
                        getX = false;
                    }
                    searchForMinumum = this.getOperationParameters().containsKey("Minimize");
                    overZ = true;
                    zwSelector = this.getOperationParameters().get("ReferenceAxis");
                    if (zwSelector != null && zwSelector.equals("w")) {
                        overZ = false;
                    }
                    try {
                        policy = SearchPolicy.valueOf(parts[1]);
                        this.nodeObject = new Characteristic3DExtremeLineReference(parts[0], policy, getX, searchForMinumum, overZ);
                        return this.nodeObject;
                    }
                    catch (Exception v4) {
                        this.nodeObject = new Characteristic3DExtremeLineInstanceReference(parts[0], parts[1], getX, searchForMinumum, overZ);
                        return this.nodeObject;
                    }
                }
                catch (Exception v5) {}
                break;
            }
            case 5: {
                try {
                    parts = this.name.substring(1).split("->");
                    if (parts.length == 2) {
                        try {
                            policy = SearchPolicy.valueOf(parts[1]);
                            this.nodeObject = new VariableReference(parts[0], policy);
                            return this.nodeObject;
                        }
                        catch (Exception v6) {
                            this.nodeObject = new VariableInstanceReference(parts[0], parts[1]);
                            return this.nodeObject;
                        }
                    }
                    return null;
                }
                catch (Exception v7) {
                    break;
                }
            }
            case 9: {
                try {
                    parts = this.name.substring(1).split("->");
                    if (parts.length == 2) {
                        try {
                            policy = SearchPolicy.valueOf(parts[1]);
                            propNameParts = parts[0].split("\\.");
                            this.nodeObject = new PropertyReference(new Property(new PropertyGroup(null, propNameParts[0]), propNameParts[1], null), policy);
                            return this.nodeObject;
                        }
                        catch (Exception v8) {
                            propNameParts = parts[0].split("\\.");
                            this.nodeObject = new PropertyInstanceReference(new Property(new PropertyGroup(null, propNameParts[0]), propNameParts[1], null), parts[1]);
                            return this.nodeObject;
                        }
                    }
                    return null;
                }
                catch (Exception v9) {
                    break;
                }
            }
        }
        try {
            if (this.name != null && this.name.startsWith("\"") && this.name.endsWith("\"")) {
                this.nodeObject = this.name.substring(1, this.name.length() - 1);
                return this.nodeObject;
            }
            if ("NaN".equals(this.name)) {
                this.nodeObject = NaN;
                return this.nodeObject;
            }
            if ("RASTER".equals(this.name)) {
                this.nodeObject = "RASTER";
                return this.nodeObject;
            }
            constant = Double.parseDouble(this.name);
            this.nodeObject = constant;
            return this.nodeObject;
        }
        catch (Exception v10) {
            try {
                operation = FormulaOperation.valueOf(this.name);
                this.nodeObject = operation;
                return this.nodeObject;
            }
            catch (Exception v11) {
                this.nodeObject = this.name != null ? this.name.trim() : null;
                return this.nodeObject;
            }
        }
    }

    public <T> T getNodeValue() {
        return (T)this.getNodeObject();
    }

    public void setOperationParameters(TreeMap<String, String> operationParameters) {
        this.operationParameters = operationParameters;
    }

    public Collection<String> getLeafParameters() {
        TreeSet<String> leafParameters = new TreeSet<String>();
        if (this.getType() == FormulaNodeType.Parameter) {
            leafParameters.add(this.name);
        }
        for (FormulaNode param : this.getParameters()) {
            leafParameters.addAll(param.getLeafParameters());
        }
        return leafParameters;
    }

    public void setOperationParameters(String parameters) {
        String[] parametersParts;
        this.operationParameters.clear();
        String[] stringArray = parametersParts = parameters.split(",");
        int n = parametersParts.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            String[] parameterParts = parameter.trim().split("=");
            if (parameterParts.length == 1) {
                this.operationParameters.put(parameterParts[0], null);
            } else if (parameterParts.length == 2) {
                this.operationParameters.put(parameterParts[0], parameterParts[1]);
            } else {
                throw new IllegalArgumentException("Illegal parameters format");
            }
            ++n2;
        }
    }

    public ArrayList<FormulaNode> getParameters() {
        return this.parameters;
    }

    public TreeMap<String, String> getOperationParameters() {
        return this.operationParameters;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getAllArgs() {
        TreeSet<String> args = new TreeSet<String>();
        if (this.getType() == FormulaNodeType.Parameter) {
            args.add(this.name);
        } else {
            for (FormulaNode param : this.getParameters()) {
                args.addAll(param.getAllArgs());
            }
        }
        return args;
    }

    public Collection<String> getAllTextConstants() {
        TreeSet<String> args = new TreeSet<String>();
        if (this.getType() == FormulaNodeType.Text) {
            args.add(this.getNodeObject().toString());
        } else {
            for (FormulaNode param : this.getParameters()) {
                args.addAll(param.getAllTextConstants());
            }
        }
        return args;
    }

    public boolean containsParameter(String parameter) {
        if (parameter.equals(this.name)) {
            return true;
        }
        if (this.parameters != null) {
            for (FormulaNode parameterNode : this.parameters) {
                if (!parameterNode.containsParameter(parameter)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsOperation(FormulaOperation operation) {
        if (operation.name().equals(this.name)) {
            return true;
        }
        if (this.parameters != null) {
            for (FormulaNode parameterNode : this.parameters) {
                if (!parameterNode.containsOperation(operation)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean containsCumulativeOperation() {
        if (this.conatainsCumulativeOperation == null) {
            this.conatainsCumulativeOperation = this.containsOperation(FormulaOperation.IntegralKum) || this.containsOperation(FormulaOperation.ReBound) || this.containsOperation(FormulaOperation.SumKum) || this.containsOperation(FormulaOperation.WindowCounter);
        }
        return this.conatainsCumulativeOperation;
    }

    public Collection<FormulaNode> findNodes(FormulaOperation ... operations) {
        HashSet<FormulaNode> nodes = new HashSet<FormulaNode>();
        FormulaOperation[] formulaOperationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaOperation operation = formulaOperationArray[n2];
            if (this.getNodeObject() == operation) {
                nodes.add(this);
            }
            for (FormulaNode childNode : this.getParameters()) {
                nodes.addAll(childNode.findNodes(operations));
            }
            ++n2;
        }
        return nodes;
    }

    public Collection<FormulaNode> findNodes(FormulaNodeType type) {
        HashSet<FormulaNode> nodes = new HashSet<FormulaNode>();
        if (this.getType() == type) {
            nodes.add(this);
        }
        for (FormulaNode childNode : this.getParameters()) {
            nodes.addAll(childNode.findNodes(type));
        }
        return nodes;
    }

    public boolean containsOperationParameter(FormulaOperation operation, String operationParameter) {
        if (operation.name().equals(this.name) && this.operationParameters.containsKey(operationParameter)) {
            return true;
        }
        if (this.parameters != null) {
            for (FormulaNode parameterNode : this.parameters) {
                if (!parameterNode.containsOperationParameter(operation, operationParameter)) continue;
                return true;
            }
        }
        return false;
    }

    public Double getMaxOperationParameter(FormulaOperation operation, String parameter) {
        String parameterValue;
        Double value = null;
        if (operation.name().equals(this.name) && (parameterValue = this.operationParameters.get(parameter)) != null) {
            Double val = Double.parseDouble(parameterValue);
            if (value == null) {
                value = val;
            }
            value = Math.max(value, val);
        }
        if (this.parameters != null) {
            for (FormulaNode parameterNode : this.parameters) {
                Double maxParameterValue = parameterNode.getMaxOperationParameter(operation, parameter);
                if (maxParameterValue == null) continue;
                if (value == null) {
                    value = maxParameterValue;
                }
                value = Double.max(value, maxParameterValue);
            }
        }
        return value;
    }

    public synchronized String toString() {
        if (this.stringRepresentation != null) {
            return this.stringRepresentation;
        }
        String result = this.name;
        if (!this.parameters.isEmpty()) {
            result = String.valueOf(result) + "( ";
            int i = 0;
            while (i < this.parameters.size()) {
                result = String.valueOf(result) + this.parameters.get(i);
                if (i < this.parameters.size() - 1) {
                    result = String.valueOf(result) + ", ";
                }
                ++i;
            }
            if (this.operationParameters.size() > 0) {
                result = String.valueOf(result) + " @ ";
            }
            int c = 0;
            for (Map.Entry<String, String> opParameter : this.operationParameters.entrySet()) {
                if (c++ > 0) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + opParameter.getKey();
                if (opParameter.getValue() == null) continue;
                result = String.valueOf(result) + "=" + opParameter.getValue();
            }
            result = String.valueOf(result) + " )";
        }
        this.stringRepresentation = result;
        return result;
    }

    public int hashCode() {
        return FormulaNode.class.hashCode() + 17 * this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FormulaNode) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$elpro$ewms$core$variable$calculated$FormulaNodeType() {
        if ($SWITCH_TABLE$de$elpro$ewms$core$variable$calculated$FormulaNodeType != null) {
            return $SWITCH_TABLE$de$elpro$ewms$core$variable$calculated$FormulaNodeType;
        }
        int[] nArray = new int[FormulaNodeType.values().length];
        try {
            nArray[FormulaNodeType.Characteristic2DRef.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.Characteristic3DExtremeLineRef.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.Characteristic3DRef.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.Constant.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.Empty.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.Operation.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.Parameter.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.PropertyRef.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.Text.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FormulaNodeType.VariableRef.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$elpro$ewms$core$variable$calculated$FormulaNodeType = nArray;
        return nArray;
    }
}

