/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.calculated.dependencies;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.variable.calculated.PropertyInstanceReference;
import de.elpro.ewms.core.variable.calculated.PropertyReference;
import de.elpro.ewms.core.variable.calculated.VariableInstanceReference;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javafx.util.StringConverter;

public class CustomAlgorithmDependencies {
    private static final Gson gson;
    public static final StringConverter<CustomAlgorithmDependencies> CONVERTER;
    private Map<String, Object> dependencies = new TreeMap<String, Object>();

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.serializeNulls();
        builder.registerTypeAdapter(CustomAlgorithmDependencies.class, (Object)new TypeAdapter<CustomAlgorithmDependencies>(){

            public void writeVarRef(JsonWriter out, VariableReference value) throws IOException {
                out.name("variable_name");
                out.value(value.getVariableName());
                out.name("search_policy");
                out.value(value.getSearchPolicy().name());
            }

            public VariableReference readVarRef(JsonReader in) throws IOException {
                String variableName = null;
                SearchPolicy searchPolicy = null;
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "variable_name": {
                            variableName = in.nextString();
                            break;
                        }
                        case "search_policy": {
                            searchPolicy = Enum.valueOf(SearchPolicy.class, in.nextString());
                            break;
                        }
                    }
                }
                if (variableName != null && searchPolicy != null) {
                    return new VariableReference(variableName, searchPolicy);
                }
                return null;
            }

            public void writeVarInstRef(JsonWriter out, VariableInstanceReference value) throws IOException {
                out.name("variable_name");
                out.value(value.getVariableName());
                out.name("structure_object_key");
                out.value(value.getStructureObjectKey());
            }

            public VariableInstanceReference readVarInstRef(JsonReader in) throws IOException {
                String variableName = null;
                String objectKey = null;
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "variable_name": {
                            variableName = in.nextString();
                            break;
                        }
                        case "structure_object_key": {
                            objectKey = in.nextString();
                            break;
                        }
                    }
                }
                if (variableName != null && objectKey != null) {
                    return new VariableInstanceReference(variableName, objectKey);
                }
                return null;
            }

            public void writePropRef(JsonWriter out, PropertyReference value) throws IOException {
                out.name("property_group_key");
                out.value(value.getProperty().getGroup().getKey());
                out.name("property_key");
                out.value(value.getProperty().getKey());
                out.name("search_policy");
                out.value(value.getSearchPolicy().name());
            }

            public PropertyReference readPropRef(JsonReader in) throws IOException {
                String propertyGroupKey = null;
                String propertyKey = null;
                SearchPolicy searchPolicy = null;
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "property_group_key": {
                            propertyGroupKey = in.nextString();
                            break;
                        }
                        case "property_key": {
                            propertyKey = in.nextString();
                            break;
                        }
                        case "search_policy": {
                            searchPolicy = Enum.valueOf(SearchPolicy.class, in.nextString());
                            break;
                        }
                    }
                }
                if (propertyGroupKey != null && propertyKey != null && searchPolicy != null) {
                    Property prop = new Property(new PropertyGroup(null, propertyGroupKey), propertyKey, null);
                    return new PropertyReference(prop, searchPolicy);
                }
                return null;
            }

            public void writePropInstRef(JsonWriter out, PropertyInstanceReference value) throws IOException {
                out.name("property_group_key");
                out.value(value.getProperty().getGroup().getKey());
                out.name("property_key");
                out.value(value.getProperty().getKey());
                out.name("structure_object_key");
                out.value(value.getStructureObjectKey());
            }

            public PropertyInstanceReference readPropInstRef(JsonReader in) throws IOException {
                String propertyGroupKey = null;
                String propertyKey = null;
                String objectKey = null;
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "property_group_key": {
                            propertyGroupKey = in.nextString();
                            break;
                        }
                        case "property_key": {
                            propertyKey = in.nextString();
                            break;
                        }
                        case "structure_object_key": {
                            objectKey = in.nextString();
                            break;
                        }
                    }
                }
                if (propertyGroupKey != null && propertyKey != null && objectKey != null) {
                    Property prop = new Property(new PropertyGroup(null, propertyGroupKey), propertyKey, null);
                    return new PropertyInstanceReference(prop, objectKey);
                }
                return null;
            }

            public CustomAlgorithmDependencies read(JsonReader in) throws IOException {
                CustomAlgorithmDependencies deps = new CustomAlgorithmDependencies();
                in.beginObject();
                String name = in.nextName();
                if ("dependencies".equals(name)) {
                    in.beginArray();
                    while (in.hasNext()) {
                        in.beginObject();
                        in.nextName();
                        String key = in.nextString();
                        in.nextName();
                        CustomAlgorithmDependencyType type = Enum.valueOf(CustomAlgorithmDependencyType.class, in.nextString());
                        in.nextName();
                        in.beginObject();
                        switch (type) {
                            case VariableReference: {
                                deps.setDependency(key, this.readVarRef(in));
                                break;
                            }
                            case VariableInstanceReference: {
                                deps.setDependency(key, this.readVarInstRef(in));
                                break;
                            }
                            case PropertyReference: {
                                deps.setDependency(key, this.readPropRef(in));
                                break;
                            }
                            case PropertyInstanceReference: {
                                deps.setDependency(key, this.readPropInstRef(in));
                                break;
                            }
                        }
                        in.endObject();
                        in.endObject();
                    }
                    in.endArray();
                }
                in.endObject();
                return deps;
            }

            public void write(JsonWriter out, CustomAlgorithmDependencies value) throws IOException {
                out.beginObject();
                out.name("dependencies");
                out.beginArray();
                for (Map.Entry<String, Object> entry : value.dependencies.entrySet()) {
                    String key = entry.getKey();
                    Object dependency = entry.getValue();
                    out.beginObject();
                    out.name("key");
                    out.value(key);
                    if (dependency instanceof VariableReference) {
                        out.name("type");
                        out.value(CustomAlgorithmDependencyType.VariableReference.name());
                        out.name("value");
                        out.beginObject();
                        this.writeVarRef(out, (VariableReference)dependency);
                        out.endObject();
                    } else if (dependency instanceof VariableInstanceReference) {
                        out.name("type");
                        out.value(CustomAlgorithmDependencyType.VariableInstanceReference.name());
                        out.name("value");
                        out.beginObject();
                        this.writeVarInstRef(out, (VariableInstanceReference)dependency);
                        out.endObject();
                    } else if (dependency instanceof PropertyReference) {
                        out.name("type");
                        out.value(CustomAlgorithmDependencyType.PropertyReference.name());
                        out.name("value");
                        out.beginObject();
                        this.writePropRef(out, (PropertyReference)dependency);
                        out.endObject();
                    } else if (dependency instanceof PropertyInstanceReference) {
                        out.name("type");
                        out.value(CustomAlgorithmDependencyType.PropertyInstanceReference.name());
                        out.name("value");
                        out.beginObject();
                        this.writePropInstRef(out, (PropertyInstanceReference)dependency);
                        out.endObject();
                    }
                    out.endObject();
                }
                out.endArray();
                out.endObject();
            }
        });
        gson = builder.create();
        CONVERTER = new StringConverter<CustomAlgorithmDependencies>(){

            public String toString(CustomAlgorithmDependencies object) {
                if (object != null) {
                    return object.toJson();
                }
                return null;
            }

            public CustomAlgorithmDependencies fromString(String string) {
                if (string == null || string.isEmpty()) {
                    return null;
                }
                return CustomAlgorithmDependencies.parse(string);
            }
        };
    }

    public Object getDependency(String key) {
        return this.dependencies.get(key);
    }

    public void setDependency(String key, Object object) {
        this.dependencies.put(key, object);
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static CustomAlgorithmDependencies parse(String json) {
        return (CustomAlgorithmDependencies)gson.fromJson(json, CustomAlgorithmDependencies.class);
    }

    private static enum CustomAlgorithmDependencyType {
        VariableReference,
        VariableInstanceReference,
        PropertyReference,
        PropertyInstanceReference;

    }
}

